/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxDatabaseResponse extends FinspaceResponse implements
        ToCopyableBuilder<GetKxDatabaseResponse.Builder, GetKxDatabaseResponse> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GetKxDatabaseResponse::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseArn").getter(getter(GetKxDatabaseResponse::databaseArn)).setter(setter(Builder::databaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetKxDatabaseResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetKxDatabaseResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(GetKxDatabaseResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(GetKxDatabaseResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> LAST_COMPLETED_CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastCompletedChangesetId").getter(getter(GetKxDatabaseResponse::lastCompletedChangesetId))
            .setter(setter(Builder::lastCompletedChangesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCompletedChangesetId").build())
            .build();

    private static final SdkField<Long> NUM_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("numBytes")
            .getter(getter(GetKxDatabaseResponse::numBytes)).setter(setter(Builder::numBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numBytes").build()).build();

    private static final SdkField<Integer> NUM_CHANGESETS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numChangesets").getter(getter(GetKxDatabaseResponse::numChangesets))
            .setter(setter(Builder::numChangesets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numChangesets").build()).build();

    private static final SdkField<Integer> NUM_FILES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numFiles").getter(getter(GetKxDatabaseResponse::numFiles)).setter(setter(Builder::numFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numFiles").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            DATABASE_ARN_FIELD, ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD,
            LAST_COMPLETED_CHANGESET_ID_FIELD, NUM_BYTES_FIELD, NUM_CHANGESETS_FIELD, NUM_FILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String databaseName;

    private final String databaseArn;

    private final String environmentId;

    private final String description;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String lastCompletedChangesetId;

    private final Long numBytes;

    private final Integer numChangesets;

    private final Integer numFiles;

    private GetKxDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.databaseArn = builder.databaseArn;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.lastCompletedChangesetId = builder.lastCompletedChangesetId;
        this.numBytes = builder.numBytes;
        this.numChangesets = builder.numChangesets;
        this.numFiles = builder.numFiles;
    }

    /**
     * <p>
     * The name of the kdb database for which the information is retrieved.
     * </p>
     * 
     * @return The name of the kdb database for which the information is retrieved.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The ARN identifier of the database.
     * </p>
     * 
     * @return The ARN identifier of the database.
     */
    public final String databaseArn() {
        return databaseArn;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A description of the database.
     * </p>
     * 
     * @return A description of the database.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp at which the database is created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the database is created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The last time that the database was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the database was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String lastCompletedChangesetId() {
        return lastCompletedChangesetId;
    }

    /**
     * <p>
     * The total number of bytes in the database.
     * </p>
     * 
     * @return The total number of bytes in the database.
     */
    public final Long numBytes() {
        return numBytes;
    }

    /**
     * <p>
     * The total number of changesets in the database.
     * </p>
     * 
     * @return The total number of changesets in the database.
     */
    public final Integer numChangesets() {
        return numChangesets;
    }

    /**
     * <p>
     * The total number of files in the database.
     * </p>
     * 
     * @return The total number of files in the database.
     */
    public final Integer numFiles() {
        return numFiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastCompletedChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(numBytes());
        hashCode = 31 * hashCode + Objects.hashCode(numChangesets());
        hashCode = 31 * hashCode + Objects.hashCode(numFiles());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxDatabaseResponse)) {
            return false;
        }
        GetKxDatabaseResponse other = (GetKxDatabaseResponse) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(databaseArn(), other.databaseArn())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(description(), other.description())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(lastCompletedChangesetId(), other.lastCompletedChangesetId())
                && Objects.equals(numBytes(), other.numBytes()) && Objects.equals(numChangesets(), other.numChangesets())
                && Objects.equals(numFiles(), other.numFiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxDatabaseResponse").add("DatabaseName", databaseName()).add("DatabaseArn", databaseArn())
                .add("EnvironmentId", environmentId()).add("Description", description())
                .add("CreatedTimestamp", createdTimestamp()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("LastCompletedChangesetId", lastCompletedChangesetId()).add("NumBytes", numBytes())
                .add("NumChangesets", numChangesets()).add("NumFiles", numFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "databaseArn":
            return Optional.ofNullable(clazz.cast(databaseArn()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "lastCompletedChangesetId":
            return Optional.ofNullable(clazz.cast(lastCompletedChangesetId()));
        case "numBytes":
            return Optional.ofNullable(clazz.cast(numBytes()));
        case "numChangesets":
            return Optional.ofNullable(clazz.cast(numChangesets()));
        case "numFiles":
            return Optional.ofNullable(clazz.cast(numFiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("databaseArn", DATABASE_ARN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("lastCompletedChangesetId", LAST_COMPLETED_CHANGESET_ID_FIELD);
        map.put("numBytes", NUM_BYTES_FIELD);
        map.put("numChangesets", NUM_CHANGESETS_FIELD);
        map.put("numFiles", NUM_FILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKxDatabaseResponse, T> g) {
        return obj -> g.apply((GetKxDatabaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKxDatabaseResponse> {
        /**
         * <p>
         * The name of the kdb database for which the information is retrieved.
         * </p>
         * 
         * @param databaseName
         *        The name of the kdb database for which the information is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The ARN identifier of the database.
         * </p>
         * 
         * @param databaseArn
         *        The ARN identifier of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseArn(String databaseArn);

        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A description of the database.
         * </p>
         * 
         * @param description
         *        A description of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp at which the database is created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the database is created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The last time that the database was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the database was modified. The value is determined as epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param lastCompletedChangesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCompletedChangesetId(String lastCompletedChangesetId);

        /**
         * <p>
         * The total number of bytes in the database.
         * </p>
         * 
         * @param numBytes
         *        The total number of bytes in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numBytes(Long numBytes);

        /**
         * <p>
         * The total number of changesets in the database.
         * </p>
         * 
         * @param numChangesets
         *        The total number of changesets in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numChangesets(Integer numChangesets);

        /**
         * <p>
         * The total number of files in the database.
         * </p>
         * 
         * @param numFiles
         *        The total number of files in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numFiles(Integer numFiles);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String databaseName;

        private String databaseArn;

        private String environmentId;

        private String description;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private String lastCompletedChangesetId;

        private Long numBytes;

        private Integer numChangesets;

        private Integer numFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxDatabaseResponse model) {
            super(model);
            databaseName(model.databaseName);
            databaseArn(model.databaseArn);
            environmentId(model.environmentId);
            description(model.description);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            lastCompletedChangesetId(model.lastCompletedChangesetId);
            numBytes(model.numBytes);
            numChangesets(model.numChangesets);
            numFiles(model.numFiles);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseArn() {
            return databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getLastCompletedChangesetId() {
            return lastCompletedChangesetId;
        }

        public final void setLastCompletedChangesetId(String lastCompletedChangesetId) {
            this.lastCompletedChangesetId = lastCompletedChangesetId;
        }

        @Override
        public final Builder lastCompletedChangesetId(String lastCompletedChangesetId) {
            this.lastCompletedChangesetId = lastCompletedChangesetId;
            return this;
        }

        public final Long getNumBytes() {
            return numBytes;
        }

        public final void setNumBytes(Long numBytes) {
            this.numBytes = numBytes;
        }

        @Override
        public final Builder numBytes(Long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        public final Integer getNumChangesets() {
            return numChangesets;
        }

        public final void setNumChangesets(Integer numChangesets) {
            this.numChangesets = numChangesets;
        }

        @Override
        public final Builder numChangesets(Integer numChangesets) {
            this.numChangesets = numChangesets;
            return this;
        }

        public final Integer getNumFiles() {
            return numFiles;
        }

        public final void setNumFiles(Integer numFiles) {
            this.numFiles = numFiles;
        }

        @Override
        public final Builder numFiles(Integer numFiles) {
            this.numFiles = numFiles;
            return this;
        }

        @Override
        public GetKxDatabaseResponse build() {
            return new GetKxDatabaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
