/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure containing the metadata of the attached clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxAttachedCluster implements SdkPojo, Serializable,
        ToCopyableBuilder<KxAttachedCluster.Builder, KxAttachedCluster> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(KxAttachedCluster::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(KxAttachedCluster::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterStatus").getter(getter(KxAttachedCluster::clusterStatusAsString))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            CLUSTER_TYPE_FIELD, CLUSTER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String clusterType;

    private final String clusterStatus;

    private KxAttachedCluster(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.clusterStatus = builder.clusterStatus;
    }

    /**
     * <p>
     * A unique name for the attached cluster.
     * </p>
     * 
     * @return A unique name for the attached cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
     * @see KxClusterType
     */
    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(clusterType);
    }

    /**
     * <p>
     * Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
     * @see KxClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * <p>
     * The status of the attached cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING – The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the attached cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING – The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final KxClusterStatus clusterStatus() {
        return KxClusterStatus.fromValue(clusterStatus);
    }

    /**
     * <p>
     * The status of the attached cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING – The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the attached cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING – The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final String clusterStatusAsString() {
        return clusterStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxAttachedCluster)) {
            return false;
        }
        KxAttachedCluster other = (KxAttachedCluster) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(clusterStatusAsString(), other.clusterStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxAttachedCluster").add("ClusterName", clusterName()).add("ClusterType", clusterTypeAsString())
                .add("ClusterStatus", clusterStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "clusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("clusterStatus", CLUSTER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxAttachedCluster, T> g) {
        return obj -> g.apply((KxAttachedCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxAttachedCluster> {
        /**
         * <p>
         * A unique name for the attached cluster.
         * </p>
         * 
         * @param clusterName
         *        A unique name for the attached cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
         * </p>
         * 
         * @param clusterType
         *        Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
         * </p>
         * 
         * @param clusterType
         *        Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(KxClusterType clusterType);

        /**
         * <p>
         * The status of the attached cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING – The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterStatus
         *        The status of the attached cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING – The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The status of the attached cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING – The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterStatus
         *        The status of the attached cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING – The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder clusterStatus(KxClusterStatus clusterStatus);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private String clusterType;

        private String clusterStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(KxAttachedCluster model) {
            clusterName(model.clusterName);
            clusterType(model.clusterType);
            clusterStatus(model.clusterStatus);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(KxClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        @Override
        public KxAttachedCluster build() {
            return new KxAttachedCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
