/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that stores the configuration details of a dataview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxDataviewConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxDataviewConfiguration.Builder, KxDataviewConfiguration> {
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewName").getter(getter(KxDataviewConfiguration::dataviewName))
            .setter(setter(Builder::dataviewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()).build();

    private static final SdkField<String> DATAVIEW_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewVersionId").getter(getter(KxDataviewConfiguration::dataviewVersionId))
            .setter(setter(Builder::dataviewVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewVersionId").build()).build();

    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(KxDataviewConfiguration::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField
            .<List<KxDataviewSegmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("segmentConfigurations")
            .getter(getter(KxDataviewConfiguration::segmentConfigurations))
            .setter(setter(Builder::segmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDataviewSegmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDataviewSegmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAVIEW_NAME_FIELD,
            DATAVIEW_VERSION_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataviewName;

    private final String dataviewVersionId;

    private final String changesetId;

    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;

    private KxDataviewConfiguration(BuilderImpl builder) {
        this.dataviewName = builder.dataviewName;
        this.dataviewVersionId = builder.dataviewVersionId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
    }

    /**
     * <p>
     * The unique identifier of the dataview.
     * </p>
     * 
     * @return The unique identifier of the dataview.
     */
    public final String dataviewName() {
        return dataviewName;
    }

    /**
     * <p>
     * The version of the dataview corresponding to a given changeset.
     * </p>
     * 
     * @return The version of the dataview corresponding to a given changeset.
     */
    public final String dataviewVersionId() {
        return dataviewVersionId;
    }

    /**
     * <p>
     * A unique identifier for the changeset.
     * </p>
     * 
     * @return A unique identifier for the changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentConfigurations() {
        return segmentConfigurations != null && !(segmentConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The db path and volume configuration for the segmented database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentConfigurations} method.
     * </p>
     * 
     * @return The db path and volume configuration for the segmented database.
     */
    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return segmentConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(dataviewVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentConfigurations() ? segmentConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewConfiguration)) {
            return false;
        }
        KxDataviewConfiguration other = (KxDataviewConfiguration) obj;
        return Objects.equals(dataviewName(), other.dataviewName())
                && Objects.equals(dataviewVersionId(), other.dataviewVersionId())
                && Objects.equals(changesetId(), other.changesetId())
                && hasSegmentConfigurations() == other.hasSegmentConfigurations()
                && Objects.equals(segmentConfigurations(), other.segmentConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxDataviewConfiguration").add("DataviewName", dataviewName())
                .add("DataviewVersionId", dataviewVersionId()).add("ChangesetId", changesetId())
                .add("SegmentConfigurations", hasSegmentConfigurations() ? segmentConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataviewName":
            return Optional.ofNullable(clazz.cast(dataviewName()));
        case "dataviewVersionId":
            return Optional.ofNullable(clazz.cast(dataviewVersionId()));
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "segmentConfigurations":
            return Optional.ofNullable(clazz.cast(segmentConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataviewName", DATAVIEW_NAME_FIELD);
        map.put("dataviewVersionId", DATAVIEW_VERSION_ID_FIELD);
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("segmentConfigurations", SEGMENT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewConfiguration, T> g) {
        return obj -> g.apply((KxDataviewConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxDataviewConfiguration> {
        /**
         * <p>
         * The unique identifier of the dataview.
         * </p>
         * 
         * @param dataviewName
         *        The unique identifier of the dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewName(String dataviewName);

        /**
         * <p>
         * The version of the dataview corresponding to a given changeset.
         * </p>
         * 
         * @param dataviewVersionId
         *        The version of the dataview corresponding to a given changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewVersionId(String dataviewVersionId);

        /**
         * <p>
         * A unique identifier for the changeset.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier for the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The db path and volume configuration for the segmented database.
         * </p>
         * 
         * @param segmentConfigurations
         *        The db path and volume configuration for the segmented database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations);

        /**
         * <p>
         * The db path and volume configuration for the segmented database.
         * </p>
         * 
         * @param segmentConfigurations
         *        The db path and volume configuration for the segmented database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations);

        /**
         * <p>
         * The db path and volume configuration for the segmented database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #segmentConfigurations(List<KxDataviewSegmentConfiguration>)}.
         * 
         * @param segmentConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentConfigurations(java.util.Collection<KxDataviewSegmentConfiguration>)
         */
        Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String dataviewName;

        private String dataviewVersionId;

        private String changesetId;

        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewConfiguration model) {
            dataviewName(model.dataviewName);
            dataviewVersionId(model.dataviewVersionId);
            changesetId(model.changesetId);
            segmentConfigurations(model.segmentConfigurations);
        }

        public final String getDataviewName() {
            return dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getDataviewVersionId() {
            return dataviewVersionId;
        }

        public final void setDataviewVersionId(String dataviewVersionId) {
            this.dataviewVersionId = dataviewVersionId;
        }

        @Override
        public final Builder dataviewVersionId(String dataviewVersionId) {
            this.dataviewVersionId = dataviewVersionId;
            return this;
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier
                    .copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration... segmentConfigurations) {
            segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder>... segmentConfigurations) {
            segmentConfigurations(Stream.of(segmentConfigurations)
                    .map(c -> KxDataviewSegmentConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public KxDataviewConfiguration build() {
            return new KxDataviewConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
