/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains the metadata of the volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxVolume implements SdkPojo, Serializable, ToCopyableBuilder<KxVolume.Builder, KxVolume> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeName").getter(getter(KxVolume::volumeName)).setter(setter(Builder::volumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(KxVolume::volumeTypeAsString)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KxVolume::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(KxVolume::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(KxVolume::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(KxVolume::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availabilityZoneIds")
            .getter(getter(KxVolume::availabilityZoneIds))
            .setter(setter(Builder::availabilityZoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(KxVolume::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(KxVolume::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD,
            VOLUME_TYPE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, STATUS_REASON_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_IDS_FIELD,
            CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeName;

    private final String volumeType;

    private final String status;

    private final String description;

    private final String statusReason;

    private final String azMode;

    private final List<String> availabilityZoneIds;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private KxVolume(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.volumeType = builder.volumeType;
        this.status = builder.status;
        this.description = builder.description;
        this.statusReason = builder.statusReason;
        this.azMode = builder.azMode;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    /**
     * <p>
     * A unique identifier for the volume.
     * </p>
     * 
     * @return A unique identifier for the volume.
     */
    public final String volumeName() {
        return volumeName;
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link KxVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * @see KxVolumeType
     */
    public final KxVolumeType volumeType() {
        return KxVolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link KxVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * @see KxVolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * The status of volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The volume creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The volume creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The volume is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The volume is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATED – The volume is successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The volume is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The volume is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxVolumeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of volume.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The volume creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The volume creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The volume is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The volume is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATED – The volume is successfully updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The volume is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The volume is successfully deleted.
     *         </p>
     *         </li>
     * @see KxVolumeStatus
     */
    public final KxVolumeStatus status() {
        return KxVolumeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The volume creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The volume creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The volume is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The volume is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATED – The volume is successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The volume is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The volume is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxVolumeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of volume.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The volume creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The volume creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The volume is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The volume is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATED – The volume is successfully updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The volume is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The volume is successfully deleted.
     *         </p>
     *         </li>
     * @see KxVolumeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the volume.
     * </p>
     * 
     * @return A description of the volume.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The error message when a failed state occurs.
     * </p>
     * 
     * @return The error message when a failed state occurs.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZoneIds() {
        return availabilityZoneIds != null && !(availabilityZoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIds} method.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final List<String> availabilityZoneIds() {
        return availabilityZoneIds;
    }

    /**
     * <p>
     * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds.
     * For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For
     * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the volume was updated in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIds() ? availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxVolume)) {
            return false;
        }
        KxVolume other = (KxVolume) obj;
        return Objects.equals(volumeName(), other.volumeName())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds()
                && Objects.equals(availabilityZoneIds(), other.availabilityZoneIds())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxVolume").add("VolumeName", volumeName()).add("VolumeType", volumeTypeAsString())
                .add("Status", statusAsString()).add("Description", description()).add("StatusReason", statusReason())
                .add("AzMode", azModeAsString())
                .add("AvailabilityZoneIds", hasAvailabilityZoneIds() ? availabilityZoneIds() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("LastModifiedTimestamp", lastModifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "volumeName":
            return Optional.ofNullable(clazz.cast(volumeName()));
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneIds":
            return Optional.ofNullable(clazz.cast(availabilityZoneIds()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxVolume, T> g) {
        return obj -> g.apply((KxVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxVolume> {
        /**
         * <p>
         * A unique identifier for the volume.
         * </p>
         * 
         * @param volumeName
         *        A unique identifier for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeName(String volumeName);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * @see KxVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * @see KxVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeType
         */
        Builder volumeType(KxVolumeType volumeType);

        /**
         * <p>
         * The status of volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The volume creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The volume creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The volume is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The volume is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATED – The volume is successfully updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The volume is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The volume is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of volume.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The volume creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The volume creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The volume is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The volume is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATED – The volume is successfully updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The volume is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The volume is successfully deleted.
         *        </p>
         *        </li>
         * @see KxVolumeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The volume creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The volume creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The volume is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The volume is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATED – The volume is successfully updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The volume is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The volume is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of volume.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The volume creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The volume creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The volume is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The volume is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATED – The volume is successfully updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The volume is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The volume is successfully deleted.
         *        </p>
         *        </li>
         * @see KxVolumeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeStatus
         */
        Builder status(KxVolumeStatus status);

        /**
         * <p>
         * A description of the volume.
         * </p>
         * 
         * @param description
         *        A description of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The error message when a failed state occurs.
         * </p>
         * 
         * @param statusReason
         *        The error message when a failed state occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(Collection<String> availabilityZoneIds);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(String... availabilityZoneIds);

        /**
         * <p>
         * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds.
         * For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the volume was updated in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String volumeName;

        private String volumeType;

        private String status;

        private String description;

        private String statusReason;

        private String azMode;

        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxVolume model) {
            volumeName(model.volumeName);
            volumeType(model.volumeType);
            status(model.status);
            description(model.description);
            statusReason(model.statusReason);
            azMode(model.azMode);
            availabilityZoneIds(model.availabilityZoneIds);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getVolumeName() {
            return volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(KxVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxVolumeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String... availabilityZoneIds) {
            availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        @Override
        public KxVolume build() {
            return new KxVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
