/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends FinspaceRequest implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateEnvironmentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("federationMode").getter(getter(UpdateEnvironmentRequest::federationModeAsString))
            .setter(setter(Builder::federationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()).build();

    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField
            .<FederationParameters> builder(MarshallingType.SDK_POJO).memberName("federationParameters")
            .getter(getter(UpdateEnvironmentRequest::federationParameters)).setter(setter(Builder::federationParameters))
            .constructor(FederationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String name;

    private final String description;

    private final String federationMode;

    private final FederationParameters federationParameters;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
    }

    /**
     * <p>
     * The identifier of the FinSpace environment.
     * </p>
     * 
     * @return The identifier of the FinSpace environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the environment.
     * </p>
     * 
     * @return The description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Authentication mode for the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return Authentication mode for the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
     *         environment.
     *         </p>
     *         </li>
     * @see FederationMode
     */
    public final FederationMode federationMode() {
        return FederationMode.fromValue(federationMode);
    }

    /**
     * <p>
     * Authentication mode for the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #federationMode}
     * will return {@link FederationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #federationModeAsString}.
     * </p>
     * 
     * @return Authentication mode for the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
     *         environment.
     *         </p>
     *         </li>
     * @see FederationMode
     */
    public final String federationModeAsString() {
        return federationMode;
    }

    /**
     * Returns the value of the FederationParameters property for this object.
     * 
     * @return The value of the FederationParameters property for this object.
     */
    public final FederationParameters federationParameters() {
        return federationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(federationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(federationModeAsString(), other.federationModeAsString())
                && Objects.equals(federationParameters(), other.federationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentRequest").add("EnvironmentId", environmentId()).add("Name", name())
                .add("Description", description()).add("FederationMode", federationModeAsString())
                .add("FederationParameters", federationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "federationMode":
            return Optional.ofNullable(clazz.cast(federationModeAsString()));
        case "federationParameters":
            return Optional.ofNullable(clazz.cast(federationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("federationParameters", FEDERATION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The identifier of the FinSpace environment.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the environment.
         * </p>
         * 
         * @param description
         *        The description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Authentication mode for the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param federationMode
         *        Authentication mode for the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity
         *        provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
         *        environment.
         *        </p>
         *        </li>
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(String federationMode);

        /**
         * <p>
         * Authentication mode for the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param federationMode
         *        Authentication mode for the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity
         *        provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace
         *        environment.
         *        </p>
         *        </li>
         * @see FederationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationMode
         */
        Builder federationMode(FederationMode federationMode);

        /**
         * Sets the value of the FederationParameters property for this object.
         *
         * @param federationParameters
         *        The new value for the FederationParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationParameters(FederationParameters federationParameters);

        /**
         * Sets the value of the FederationParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FederationParameters.Builder} avoiding
         * the need to create one manually via {@link FederationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederationParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #federationParameters(FederationParameters)}.
         * 
         * @param federationParameters
         *        a consumer that will call methods on {@link FederationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federationParameters(FederationParameters)
         */
        default Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return federationParameters(FederationParameters.builder().applyMutation(federationParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String name;

        private String description;

        private String federationMode;

        private FederationParameters federationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            environmentId(model.environmentId);
            name(model.name);
            description(model.description);
            federationMode(model.federationMode);
            federationParameters(model.federationParameters);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFederationMode() {
            return federationMode;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return federationParameters != null ? federationParameters.toBuilder() : null;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
