/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKxClusterCodeConfigurationRequest extends FinspaceRequest implements
        ToCopyableBuilder<UpdateKxClusterCodeConfigurationRequest.Builder, UpdateKxClusterCodeConfigurationRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateKxClusterCodeConfigurationRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateKxClusterCodeConfigurationRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateKxClusterCodeConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CodeConfiguration> CODE_FIELD = SdkField.<CodeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("code").getter(getter(UpdateKxClusterCodeConfigurationRequest::code)).setter(setter(Builder::code))
            .constructor(CodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initializationScript").getter(getter(UpdateKxClusterCodeConfigurationRequest::initializationScript))
            .setter(setter(Builder::initializationScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build())
            .build();

    private static final SdkField<List<KxCommandLineArgument>> COMMAND_LINE_ARGUMENTS_FIELD = SdkField
            .<List<KxCommandLineArgument>> builder(MarshallingType.LIST)
            .memberName("commandLineArguments")
            .getter(getter(UpdateKxClusterCodeConfigurationRequest::commandLineArguments))
            .setter(setter(Builder::commandLineArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandLineArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxCommandLineArgument> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxCommandLineArgument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KxClusterCodeDeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<KxClusterCodeDeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(UpdateKxClusterCodeConfigurationRequest::deploymentConfiguration))
            .setter(setter(Builder::deploymentConfiguration)).constructor(KxClusterCodeDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            CLUSTER_NAME_FIELD, CLIENT_TOKEN_FIELD, CODE_FIELD, INITIALIZATION_SCRIPT_FIELD, COMMAND_LINE_ARGUMENTS_FIELD,
            DEPLOYMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String clusterName;

    private final String clientToken;

    private final CodeConfiguration code;

    private final String initializationScript;

    private final List<KxCommandLineArgument> commandLineArguments;

    private final KxClusterCodeDeploymentConfiguration deploymentConfiguration;

    private UpdateKxClusterCodeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.code = builder.code;
        this.initializationScript = builder.initializationScript;
        this.commandLineArguments = builder.commandLineArguments;
        this.deploymentConfiguration = builder.deploymentConfiguration;
    }

    /**
     * <p>
     * A unique identifier of the kdb environment.
     * </p>
     * 
     * @return A unique identifier of the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public final CodeConfiguration code() {
        return code;
    }

    /**
     * <p>
     * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that
     * contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example,
     * <code>somedir/init.q</code>.
     * </p>
     * <p>
     * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
     * </p>
     * 
     * @return Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i>
     *         file that contains the custom code, which will be loaded on the cluster. It must include the file name
     *         itself. For example, <code>somedir/init.q</code>.</p>
     *         <p>
     *         You cannot update this parameter for a <code>NO_RESTART</code> deployment.
     */
    public final String initializationScript() {
        return initializationScript;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommandLineArguments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommandLineArguments() {
        return commandLineArguments != null && !(commandLineArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs to make them available inside the cluster.
     * </p>
     * <p>
     * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommandLineArguments} method.
     * </p>
     * 
     * @return Specifies the key-value pairs to make them available inside the cluster.</p>
     *         <p>
     *         You cannot update this parameter for a <code>NO_RESTART</code> deployment.
     */
    public final List<KxCommandLineArgument> commandLineArguments() {
        return commandLineArguments;
    }

    /**
     * <p>
     * The configuration that allows you to choose how you want to update the code on a cluster.
     * </p>
     * 
     * @return The configuration that allows you to choose how you want to update the code on a cluster.
     */
    public final KxClusterCodeDeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommandLineArguments() ? commandLineArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxClusterCodeConfigurationRequest)) {
            return false;
        }
        UpdateKxClusterCodeConfigurationRequest other = (UpdateKxClusterCodeConfigurationRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(code(), other.code())
                && Objects.equals(initializationScript(), other.initializationScript())
                && hasCommandLineArguments() == other.hasCommandLineArguments()
                && Objects.equals(commandLineArguments(), other.commandLineArguments())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKxClusterCodeConfigurationRequest").add("EnvironmentId", environmentId())
                .add("ClusterName", clusterName()).add("ClientToken", clientToken()).add("Code", code())
                .add("InitializationScript", initializationScript())
                .add("CommandLineArguments", hasCommandLineArguments() ? commandLineArguments() : null)
                .add("DeploymentConfiguration", deploymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "initializationScript":
            return Optional.ofNullable(clazz.cast(initializationScript()));
        case "commandLineArguments":
            return Optional.ofNullable(clazz.cast(commandLineArguments()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("code", CODE_FIELD);
        map.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
        map.put("commandLineArguments", COMMAND_LINE_ARGUMENTS_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxClusterCodeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateKxClusterCodeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateKxClusterCodeConfigurationRequest> {
        /**
         * <p>
         * A unique identifier of the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier of the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(CodeConfiguration code);

        /**
         * Sets the value of the Code property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodeConfiguration.Builder} avoiding the
         * need to create one manually via {@link CodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #code(CodeConfiguration)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link CodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(CodeConfiguration)
         */
        default Builder code(Consumer<CodeConfiguration.Builder> code) {
            return code(CodeConfiguration.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file
         * that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For
         * example, <code>somedir/init.q</code>.
         * </p>
         * <p>
         * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * </p>
         * 
         * @param initializationScript
         *        Specifies a Q program that will be run at launch of a cluster. It is a relative path within
         *        <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include
         *        the file name itself. For example, <code>somedir/init.q</code>.</p>
         *        <p>
         *        You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScript(String initializationScript);

        /**
         * <p>
         * Specifies the key-value pairs to make them available inside the cluster.
         * </p>
         * <p>
         * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * </p>
         * 
         * @param commandLineArguments
         *        Specifies the key-value pairs to make them available inside the cluster.</p>
         *        <p>
         *        You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments);

        /**
         * <p>
         * Specifies the key-value pairs to make them available inside the cluster.
         * </p>
         * <p>
         * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * </p>
         * 
         * @param commandLineArguments
         *        Specifies the key-value pairs to make them available inside the cluster.</p>
         *        <p>
         *        You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandLineArguments(KxCommandLineArgument... commandLineArguments);

        /**
         * <p>
         * Specifies the key-value pairs to make them available inside the cluster.
         * </p>
         * <p>
         * You cannot update this parameter for a <code>NO_RESTART</code> deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder#build()} is called
         * immediately and its result is passed to {@link #commandLineArguments(List<KxCommandLineArgument>)}.
         * 
         * @param commandLineArguments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxCommandLineArgument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commandLineArguments(java.util.Collection<KxCommandLineArgument>)
         */
        Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder>... commandLineArguments);

        /**
         * <p>
         * The configuration that allows you to choose how you want to update the code on a cluster.
         * </p>
         * 
         * @param deploymentConfiguration
         *        The configuration that allows you to choose how you want to update the code on a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(KxClusterCodeDeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * The configuration that allows you to choose how you want to update the code on a cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KxClusterCodeDeploymentConfiguration.Builder} avoiding the need to create one manually via
         * {@link KxClusterCodeDeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxClusterCodeDeploymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deploymentConfiguration(KxClusterCodeDeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link KxClusterCodeDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(KxClusterCodeDeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<KxClusterCodeDeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(KxClusterCodeDeploymentConfiguration.builder().applyMutation(deploymentConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String clusterName;

        private String clientToken;

        private CodeConfiguration code;

        private String initializationScript;

        private List<KxCommandLineArgument> commandLineArguments = DefaultSdkAutoConstructList.getInstance();

        private KxClusterCodeDeploymentConfiguration deploymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxClusterCodeConfigurationRequest model) {
            super(model);
            environmentId(model.environmentId);
            clusterName(model.clusterName);
            clientToken(model.clientToken);
            code(model.code);
            initializationScript(model.initializationScript);
            commandLineArguments(model.commandLineArguments);
            deploymentConfiguration(model.deploymentConfiguration);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CodeConfiguration.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(CodeConfiguration.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CodeConfiguration code) {
            this.code = code;
            return this;
        }

        public final String getInitializationScript() {
            return initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final List<KxCommandLineArgument.Builder> getCommandLineArguments() {
            List<KxCommandLineArgument.Builder> result = KxCommandLineArgumentsCopier.copyToBuilder(this.commandLineArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandLineArguments(Collection<KxCommandLineArgument.BuilderImpl> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copyFromBuilder(commandLineArguments);
        }

        @Override
        public final Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copy(commandLineArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(KxCommandLineArgument... commandLineArguments) {
            commandLineArguments(Arrays.asList(commandLineArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder>... commandLineArguments) {
            commandLineArguments(Stream.of(commandLineArguments)
                    .map(c -> KxCommandLineArgument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final KxClusterCodeDeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(KxClusterCodeDeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(KxClusterCodeDeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxClusterCodeConfigurationRequest build() {
            return new UpdateKxClusterCodeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
