/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that consists of name and type of volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeName").getter(getter(Volume::volumeName)).setter(setter(Builder::volumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(Volume::volumeTypeAsString)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD,
            VOLUME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeName;

    private final String volumeType;

    private Volume(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * A unique identifier for the volume.
     * </p>
     * 
     * @return A unique identifier for the volume.
     */
    public final String volumeName() {
        return volumeName;
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(volumeName(), other.volumeName())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("VolumeName", volumeName()).add("VolumeType", volumeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "volumeName":
            return Optional.ofNullable(clazz.cast(volumeName()));
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * A unique identifier for the volume.
         * </p>
         * 
         * @param volumeName
         *        A unique identifier for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeName(String volumeName);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);
    }

    static final class BuilderImpl implements Builder {
        private String volumeName;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            volumeName(model.volumeName);
            volumeType(model.volumeType);
        }

        public final String getVolumeName() {
            return volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
