/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of change request objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeRequest implements SdkPojo, Serializable, ToCopyableBuilder<ChangeRequest.Builder, ChangeRequest> {
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(ChangeRequest::changeTypeAsString)).setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Path")
            .getter(getter(ChangeRequest::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()).build();

    private static final SdkField<String> DB_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dbPath")
            .getter(getter(ChangeRequest::dbPath)).setter(setter(Builder::dbPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_FIELD,
            S3_PATH_FIELD, DB_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String changeType;

    private final String s3Path;

    private final String dbPath;

    private ChangeRequest(BuilderImpl builder) {
        this.changeType = builder.changeType;
        this.s3Path = builder.s3Path;
        this.dbPath = builder.dbPath;
    }

    /**
     * <p>
     * Defines the type of change request. A <code>changeType</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT – Adds or updates files in a database.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE – Deletes files in a database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Defines the type of change request. A <code>changeType</code> can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT – Adds or updates files in a database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE – Deletes files in a database.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Defines the type of change request. A <code>changeType</code> can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT – Adds or updates files in a database.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE – Deletes files in a database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Defines the type of change request. A <code>changeType</code> can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT – Adds or updates files in a database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE – Deletes files in a database.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    /**
     * <p>
     * Defines the S3 path of the source file that is required to add or update files in a database.
     * </p>
     * 
     * @return Defines the S3 path of the source file that is required to add or update files in a database.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * Defines the path within the database directory.
     * </p>
     * 
     * @return Defines the path within the database directory.
     */
    public final String dbPath() {
        return dbPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(dbPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeRequest)) {
            return false;
        }
        ChangeRequest other = (ChangeRequest) obj;
        return Objects.equals(changeTypeAsString(), other.changeTypeAsString()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(dbPath(), other.dbPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeRequest").add("ChangeType", changeTypeAsString()).add("S3Path", s3Path())
                .add("DbPath", dbPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        case "s3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "dbPath":
            return Optional.ofNullable(clazz.cast(dbPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("changeType", CHANGE_TYPE_FIELD);
        map.put("s3Path", S3_PATH_FIELD);
        map.put("dbPath", DB_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeRequest, T> g) {
        return obj -> g.apply((ChangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeRequest> {
        /**
         * <p>
         * Defines the type of change request. A <code>changeType</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT – Adds or updates files in a database.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE – Deletes files in a database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Defines the type of change request. A <code>changeType</code> can have the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT – Adds or updates files in a database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE – Deletes files in a database.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Defines the type of change request. A <code>changeType</code> can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT – Adds or updates files in a database.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE – Deletes files in a database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Defines the type of change request. A <code>changeType</code> can have the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT – Adds or updates files in a database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE – Deletes files in a database.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);

        /**
         * <p>
         * Defines the S3 path of the source file that is required to add or update files in a database.
         * </p>
         * 
         * @param s3Path
         *        Defines the S3 path of the source file that is required to add or update files in a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * Defines the path within the database directory.
         * </p>
         * 
         * @param dbPath
         *        Defines the path within the database directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPath(String dbPath);
    }

    static final class BuilderImpl implements Builder {
        private String changeType;

        private String s3Path;

        private String dbPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeRequest model) {
            changeType(model.changeType);
            s3Path(model.s3Path);
            dbPath(model.dbPath);
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getDbPath() {
            return dbPath;
        }

        public final void setDbPath(String dbPath) {
            this.dbPath = dbPath;
        }

        @Override
        public final Builder dbPath(String dbPath) {
            this.dbPath = dbPath;
            return this;
        }

        @Override
        public ChangeRequest build() {
            return new ChangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
