/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKxChangesetRequest extends FinspaceRequest implements
        ToCopyableBuilder<CreateKxChangesetRequest.Builder, CreateKxChangesetRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateKxChangesetRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(CreateKxChangesetRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("databaseName").build()).build();

    private static final SdkField<List<ChangeRequest>> CHANGE_REQUESTS_FIELD = SdkField
            .<List<ChangeRequest>> builder(MarshallingType.LIST)
            .memberName("changeRequests")
            .getter(getter(CreateKxChangesetRequest::changeRequests))
            .setter(setter(Builder::changeRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateKxChangesetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            DATABASE_NAME_FIELD, CHANGE_REQUESTS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String databaseName;

    private final List<ChangeRequest> changeRequests;

    private final String clientToken;

    private CreateKxChangesetRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.databaseName = builder.databaseName;
        this.changeRequests = builder.changeRequests;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A unique identifier of the kdb environment.
     * </p>
     * 
     * @return A unique identifier of the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the kdb database.
     * </p>
     * 
     * @return The name of the kdb database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeRequests() {
        return changeRequests != null && !(changeRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of change request objects that are run in order. A change request object consists of
     * <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT – Adds or updates files in a database.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE – Deletes files in a database.
     * </p>
     * </li>
     * </ul>
     * <p>
     * All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within the
     * database directory. All database paths must start with a leading / and end with a trailing /. The
     * <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The
     * <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if it is a
     * file.
     * </p>
     * <p>
     * Here are few examples of how you can use the change request object:
     * </p>
     * <ol>
     * <li>
     * <p>
     * This request adds a single sym file at database root location.
     * </p>
     * <p>
     * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.
     * </p>
     * <p>
     * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the database.
     * </p>
     * <p>
     * <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * This request deletes the 2020.01.02 partition of the database.
     * </p>
     * <p>
     * <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the database,
     * and the <i>PUT</i> request adds a new taq table under it.
     * </p>
     * <p>
     * <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
     * </p>
     * </li>
     * </ol>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeRequests} method.
     * </p>
     * 
     * @return A list of change request objects that are run in order. A change request object consists of
     *         <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the
     *         following values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT – Adds or updates files in a database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE – Deletes files in a database.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within
     *         the database directory. All database paths must start with a leading / and end with a trailing /. The
     *         <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The
     *         <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if
     *         it is a file.
     *         </p>
     *         <p>
     *         Here are few examples of how you can use the change request object:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         This request adds a single sym file at database root location.
     *         </p>
     *         <p>
     *         <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.
     *         </p>
     *         <p>
     *         <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
     *         database.
     *         </p>
     *         <p>
     *         <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This request deletes the 2020.01.02 partition of the database.
     *         </p>
     *         <p>
     *         <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the
     *         database, and the <i>PUT</i> request adds a new taq table under it.
     *         </p>
     *         <p>
     *         <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
     *         </p>
     *         </li>
     */
    public final List<ChangeRequest> changeRequests() {
        return changeRequests;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeRequests() ? changeRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxChangesetRequest)) {
            return false;
        }
        CreateKxChangesetRequest other = (CreateKxChangesetRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(databaseName(), other.databaseName())
                && hasChangeRequests() == other.hasChangeRequests() && Objects.equals(changeRequests(), other.changeRequests())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKxChangesetRequest").add("EnvironmentId", environmentId())
                .add("DatabaseName", databaseName()).add("ChangeRequests", hasChangeRequests() ? changeRequests() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "changeRequests":
            return Optional.ofNullable(clazz.cast(changeRequests()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("changeRequests", CHANGE_REQUESTS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxChangesetRequest, T> g) {
        return obj -> g.apply((CreateKxChangesetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKxChangesetRequest> {
        /**
         * <p>
         * A unique identifier of the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier of the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the kdb database.
         * </p>
         * 
         * @param databaseName
         *        The name of the kdb database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A list of change request objects that are run in order. A change request object consists of
         * <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT – Adds or updates files in a database.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE – Deletes files in a database.
         * </p>
         * </li>
         * </ul>
         * <p>
         * All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within the
         * database directory. All database paths must start with a leading / and end with a trailing /. The
         * <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The
         * <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if it
         * is a file.
         * </p>
         * <p>
         * Here are few examples of how you can use the change request object:
         * </p>
         * <ol>
         * <li>
         * <p>
         * This request adds a single sym file at database root location.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
         * database.
         * </p>
         * <p>
         * <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request deletes the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the
         * database, and the <i>PUT</i> request adds a new taq table under it.
         * </p>
         * <p>
         * <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * </ol>
         * 
         * @param changeRequests
         *        A list of change request objects that are run in order. A change request object consists of
         *        <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the
         *        following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT – Adds or updates files in a database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE – Deletes files in a database.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within
         *        the database directory. All database paths must start with a leading / and end with a trailing /. The
         *        <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type.
         *        The <code>s3path</code> must end with a trailing / if it is a directory and must end without a
         *        trailing / if it is a file.
         *        </p>
         *        <p>
         *        Here are few examples of how you can use the change request object:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        This request adds a single sym file at database root location.
         *        </p>
         *        <p>
         *        <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the
         *        database.
         *        </p>
         *        <p>
         *        <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
         *        database.
         *        </p>
         *        <p>
         *        <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request deletes the 2020.01.02 partition of the database.
         *        </p>
         *        <p>
         *        <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of
         *        the database, and the <i>PUT</i> request adds a new taq table under it.
         *        </p>
         *        <p>
         *        <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequests(Collection<ChangeRequest> changeRequests);

        /**
         * <p>
         * A list of change request objects that are run in order. A change request object consists of
         * <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT – Adds or updates files in a database.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE – Deletes files in a database.
         * </p>
         * </li>
         * </ul>
         * <p>
         * All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within the
         * database directory. All database paths must start with a leading / and end with a trailing /. The
         * <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The
         * <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if it
         * is a file.
         * </p>
         * <p>
         * Here are few examples of how you can use the change request object:
         * </p>
         * <ol>
         * <li>
         * <p>
         * This request adds a single sym file at database root location.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
         * database.
         * </p>
         * <p>
         * <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request deletes the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the
         * database, and the <i>PUT</i> request adds a new taq table under it.
         * </p>
         * <p>
         * <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * </ol>
         * 
         * @param changeRequests
         *        A list of change request objects that are run in order. A change request object consists of
         *        <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the
         *        following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT – Adds or updates files in a database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE – Deletes files in a database.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within
         *        the database directory. All database paths must start with a leading / and end with a trailing /. The
         *        <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type.
         *        The <code>s3path</code> must end with a trailing / if it is a directory and must end without a
         *        trailing / if it is a file.
         *        </p>
         *        <p>
         *        Here are few examples of how you can use the change request object:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        This request adds a single sym file at database root location.
         *        </p>
         *        <p>
         *        <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the
         *        database.
         *        </p>
         *        <p>
         *        <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
         *        database.
         *        </p>
         *        <p>
         *        <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This request deletes the 2020.01.02 partition of the database.
         *        </p>
         *        <p>
         *        <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of
         *        the database, and the <i>PUT</i> request adds a new taq table under it.
         *        </p>
         *        <p>
         *        <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequests(ChangeRequest... changeRequests);

        /**
         * <p>
         * A list of change request objects that are run in order. A change request object consists of
         * <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT – Adds or updates files in a database.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE – Deletes files in a database.
         * </p>
         * </li>
         * </ul>
         * <p>
         * All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within the
         * database directory. All database paths must start with a leading / and end with a trailing /. The
         * <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The
         * <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if it
         * is a file.
         * </p>
         * <p>
         * Here are few examples of how you can use the change request object:
         * </p>
         * <ol>
         * <li>
         * <p>
         * This request adds a single sym file at database root location.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the
         * database.
         * </p>
         * <p>
         * <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * This request deletes the 2020.01.02 partition of the database.
         * </p>
         * <p>
         * <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the
         * database, and the <i>PUT</i> request adds a new taq table under it.
         * </p>
         * <p>
         * <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code>
         * </p>
         * </li>
         * </ol>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.ChangeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #changeRequests(List<ChangeRequest>)}.
         * 
         * @param changeRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.ChangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeRequests(java.util.Collection<ChangeRequest>)
         */
        Builder changeRequests(Consumer<ChangeRequest.Builder>... changeRequests);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String databaseName;

        private List<ChangeRequest> changeRequests = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxChangesetRequest model) {
            super(model);
            environmentId(model.environmentId);
            databaseName(model.databaseName);
            changeRequests(model.changeRequests);
            clientToken(model.clientToken);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final List<ChangeRequest.Builder> getChangeRequests() {
            List<ChangeRequest.Builder> result = ChangeRequestsCopier.copyToBuilder(this.changeRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeRequests(Collection<ChangeRequest.BuilderImpl> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copyFromBuilder(changeRequests);
        }

        @Override
        public final Builder changeRequests(Collection<ChangeRequest> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copy(changeRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(ChangeRequest... changeRequests) {
            changeRequests(Arrays.asList(changeRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(Consumer<ChangeRequest.Builder>... changeRequests) {
            changeRequests(Stream.of(changeRequests).map(c -> ChangeRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxChangesetRequest build() {
            return new CreateKxChangesetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
