/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKxVolumeRequest extends FinspaceRequest implements
        ToCopyableBuilder<CreateKxVolumeRequest.Builder, CreateKxVolumeRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateKxVolumeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateKxVolumeRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(CreateKxVolumeRequest::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeName").getter(getter(CreateKxVolumeRequest::volumeName)).setter(setter(Builder::volumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateKxVolumeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<KxNAS1Configuration> NAS1_CONFIGURATION_FIELD = SdkField
            .<KxNAS1Configuration> builder(MarshallingType.SDK_POJO).memberName("nas1Configuration")
            .getter(getter(CreateKxVolumeRequest::nas1Configuration)).setter(setter(Builder::nas1Configuration))
            .constructor(KxNAS1Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nas1Configuration").build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(CreateKxVolumeRequest::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availabilityZoneIds")
            .getter(getter(CreateKxVolumeRequest::availabilityZoneIds))
            .setter(setter(Builder::availabilityZoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateKxVolumeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ENVIRONMENT_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_NAME_FIELD, DESCRIPTION_FIELD, NAS1_CONFIGURATION_FIELD,
            AZ_MODE_FIELD, AVAILABILITY_ZONE_IDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String environmentId;

    private final String volumeType;

    private final String volumeName;

    private final String description;

    private final KxNAS1Configuration nas1Configuration;

    private final String azMode;

    private final List<String> availabilityZoneIds;

    private final Map<String, String> tags;

    private CreateKxVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.volumeType = builder.volumeType;
        this.volumeName = builder.volumeName;
        this.description = builder.description;
        this.nas1Configuration = builder.nas1Configuration;
        this.azMode = builder.azMode;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment, whose clusters can attach to the volume.
     * </p>
     * 
     * @return A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When you select
     * <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link KxVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When
     *         you select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
     * @see KxVolumeType
     */
    public final KxVolumeType volumeType() {
        return KxVolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When you select
     * <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link KxVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When
     *         you select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
     * @see KxVolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * A unique identifier for the volume.
     * </p>
     * 
     * @return A unique identifier for the volume.
     */
    public final String volumeName() {
        return volumeName;
    }

    /**
     * <p>
     * A description of the volume.
     * </p>
     * 
     * @return A description of the volume.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is
     * required when you choose <code>volumeType</code> as <i>NAS_1</i>.
     * </p>
     * 
     * @return Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter
     *         is required when you choose <code>volumeType</code> as <i>NAS_1</i>.
     */
    public final KxNAS1Configuration nas1Configuration() {
        return nas1Configuration;
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones you want to assign per volume. Currently, FinSpace only supports
     *         <code>SINGLE</code> for volumes. This places dataview in a single AZ.
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZoneIds() {
        return availabilityZoneIds != null && !(availabilityZoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIds} method.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final List<String> availabilityZoneIds() {
        return availabilityZoneIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nas1Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIds() ? availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxVolumeRequest)) {
            return false;
        }
        CreateKxVolumeRequest other = (CreateKxVolumeRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(volumeName(), other.volumeName()) && Objects.equals(description(), other.description())
                && Objects.equals(nas1Configuration(), other.nas1Configuration())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds()
                && Objects.equals(availabilityZoneIds(), other.availabilityZoneIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKxVolumeRequest").add("ClientToken", clientToken()).add("EnvironmentId", environmentId())
                .add("VolumeType", volumeTypeAsString()).add("VolumeName", volumeName()).add("Description", description())
                .add("Nas1Configuration", nas1Configuration()).add("AzMode", azModeAsString())
                .add("AvailabilityZoneIds", hasAvailabilityZoneIds() ? availabilityZoneIds() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "volumeName":
            return Optional.ofNullable(clazz.cast(volumeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nas1Configuration":
            return Optional.ofNullable(clazz.cast(nas1Configuration()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneIds":
            return Optional.ofNullable(clazz.cast(availabilityZoneIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nas1Configuration", NAS1_CONFIGURATION_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxVolumeRequest, T> g) {
        return obj -> g.apply((CreateKxVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKxVolumeRequest> {
        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A unique identifier for the kdb environment, whose clusters can attach to the volume.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment, whose clusters can attach to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When you
         * select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When
         *        you select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
         * @see KxVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When you
         * select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
         * </p>
         * 
         * @param volumeType
         *        The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When
         *        you select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>.
         * @see KxVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxVolumeType
         */
        Builder volumeType(KxVolumeType volumeType);

        /**
         * <p>
         * A unique identifier for the volume.
         * </p>
         * 
         * @param volumeName
         *        A unique identifier for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeName(String volumeName);

        /**
         * <p>
         * A description of the volume.
         * </p>
         * 
         * @param description
         *        A description of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is
         * required when you choose <code>volumeType</code> as <i>NAS_1</i>.
         * </p>
         * 
         * @param nas1Configuration
         *        Specifies the configuration for the Network attached storage (NAS_1) file system volume. This
         *        parameter is required when you choose <code>volumeType</code> as <i>NAS_1</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nas1Configuration(KxNAS1Configuration nas1Configuration);

        /**
         * <p>
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is
         * required when you choose <code>volumeType</code> as <i>NAS_1</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link KxNAS1Configuration.Builder} avoiding the
         * need to create one manually via {@link KxNAS1Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxNAS1Configuration.Builder#build()} is called immediately and
         * its result is passed to {@link #nas1Configuration(KxNAS1Configuration)}.
         * 
         * @param nas1Configuration
         *        a consumer that will call methods on {@link KxNAS1Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nas1Configuration(KxNAS1Configuration)
         */
        default Builder nas1Configuration(Consumer<KxNAS1Configuration.Builder> nas1Configuration) {
            return nas1Configuration(KxNAS1Configuration.builder().applyMutation(nas1Configuration).build());
        }

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         * <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * </p>
         * 
         * @param azMode
         *        The number of availability zones you want to assign per volume. Currently, FinSpace only supports
         *        <code>SINGLE</code> for volumes. This places dataview in a single AZ.
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(Collection<String> availabilityZoneIds);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(String... availabilityZoneIds);

        /**
         * <p>
         * A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the volume. You can add up to 50 tags to a volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String environmentId;

        private String volumeType;

        private String volumeName;

        private String description;

        private KxNAS1Configuration nas1Configuration;

        private String azMode;

        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxVolumeRequest model) {
            super(model);
            clientToken(model.clientToken);
            environmentId(model.environmentId);
            volumeType(model.volumeType);
            volumeName(model.volumeName);
            description(model.description);
            nas1Configuration(model.nas1Configuration);
            azMode(model.azMode);
            availabilityZoneIds(model.availabilityZoneIds);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(KxVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getVolumeName() {
            return volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KxNAS1Configuration.Builder getNas1Configuration() {
            return nas1Configuration != null ? nas1Configuration.toBuilder() : null;
        }

        public final void setNas1Configuration(KxNAS1Configuration.BuilderImpl nas1Configuration) {
            this.nas1Configuration = nas1Configuration != null ? nas1Configuration.build() : null;
        }

        @Override
        public final Builder nas1Configuration(KxNAS1Configuration nas1Configuration) {
            this.nas1Configuration = nas1Configuration;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String... availabilityZoneIds) {
            availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKxVolumeRequest build() {
            return new CreateKxVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
