/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details in the event of a failed flow, including the error type and the related error message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ErrorInfo.Builder, ErrorInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ErrorInfo::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(ErrorInfo::errorTypeAsString)).setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            ERROR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String errorType;

    private ErrorInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
    }

    /**
     * <p>
     * Specifies the error message that appears if a flow fails.
     * </p>
     * 
     * @return Specifies the error message that appears if a flow fails.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Specifies the type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ErrorDetails#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of error.
     * @see ErrorDetails
     */
    public final ErrorDetails errorType() {
        return ErrorDetails.fromValue(errorType);
    }

    /**
     * <p>
     * Specifies the type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ErrorDetails#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of error.
     * @see ErrorDetails
     */
    public final String errorTypeAsString() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo) obj;
        return Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorTypeAsString(), other.errorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInfo").add("ErrorMessage", errorMessage()).add("ErrorType", errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInfo> {
        /**
         * <p>
         * Specifies the error message that appears if a flow fails.
         * </p>
         * 
         * @param errorMessage
         *        Specifies the error message that appears if a flow fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Specifies the type of error.
         * </p>
         * 
         * @param errorType
         *        Specifies the type of error.
         * @see ErrorDetails
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorDetails
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * Specifies the type of error.
         * </p>
         * 
         * @param errorType
         *        Specifies the type of error.
         * @see ErrorDetails
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorDetails
         */
        Builder errorType(ErrorDetails errorType);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            errorMessage(model.errorMessage);
            errorType(model.errorType);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ErrorDetails errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
