/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for read only disk cache associated with a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxCacheStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxCacheStorageConfiguration.Builder, KxCacheStorageConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(KxCacheStorageConfiguration::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(KxCacheStorageConfiguration::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer size;

    private KxCacheStorageConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.size = builder.size;
    }

    /**
     * <p>
     * The type of cache storage. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_250 – This type provides at least 250 MB/s disk access throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_12 – This type provides at least 12 MB/s disk access throughput.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For cache type <code>CACHE_1000</code> and <code>CACHE_250</code> you can select cache size as 1200 GB or
     * increments of 2400 GB. For cache type <code>CACHE_12</code> you can select the cache size in increments of 6000
     * GB.
     * </p>
     * 
     * @return The type of cache storage. The valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_250 – This type provides at least 250 MB/s disk access throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_12 – This type provides at least 12 MB/s disk access throughput.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For cache type <code>CACHE_1000</code> and <code>CACHE_250</code> you can select cache size as 1200 GB or
     *         increments of 2400 GB. For cache type <code>CACHE_12</code> you can select the cache size in increments
     *         of 6000 GB.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The size of cache in Gigabytes.
     * </p>
     * 
     * @return The size of cache in Gigabytes.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxCacheStorageConfiguration)) {
            return false;
        }
        KxCacheStorageConfiguration other = (KxCacheStorageConfiguration) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxCacheStorageConfiguration").add("Type", type()).add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("size", SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxCacheStorageConfiguration, T> g) {
        return obj -> g.apply((KxCacheStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxCacheStorageConfiguration> {
        /**
         * <p>
         * The type of cache storage. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_250 – This type provides at least 250 MB/s disk access throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_12 – This type provides at least 12 MB/s disk access throughput.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For cache type <code>CACHE_1000</code> and <code>CACHE_250</code> you can select cache size as 1200 GB or
         * increments of 2400 GB. For cache type <code>CACHE_12</code> you can select the cache size in increments of
         * 6000 GB.
         * </p>
         * 
         * @param type
         *        The type of cache storage. The valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_250 – This type provides at least 250 MB/s disk access throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_12 – This type provides at least 12 MB/s disk access throughput.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For cache type <code>CACHE_1000</code> and <code>CACHE_250</code> you can select cache size as 1200 GB
         *        or increments of 2400 GB. For cache type <code>CACHE_12</code> you can select the cache size in
         *        increments of 6000 GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The size of cache in Gigabytes.
         * </p>
         * 
         * @param size
         *        The size of cache in Gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(KxCacheStorageConfiguration model) {
            type(model.type);
            size(model.size);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public KxCacheStorageConfiguration build() {
            return new KxCacheStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
