/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a kdb cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxCluster implements SdkPojo, Serializable, ToCopyableBuilder<KxCluster.Builder, KxCluster> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KxCluster::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(KxCluster::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(KxCluster::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(KxCluster::clusterTypeAsString)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> CLUSTER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterDescription").getter(getter(KxCluster::clusterDescription))
            .setter(setter(Builder::clusterDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDescription").build())
            .build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(KxCluster::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(KxCluster::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initializationScript").getter(getter(KxCluster::initializationScript))
            .setter(setter(Builder::initializationScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(KxCluster::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("azMode")
            .getter(getter(KxCluster::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(KxCluster::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(KxCluster::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(KxCluster::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, CLUSTER_NAME_FIELD, CLUSTER_TYPE_FIELD, CLUSTER_DESCRIPTION_FIELD, RELEASE_LABEL_FIELD,
            VOLUMES_FIELD, INITIALIZATION_SCRIPT_FIELD, EXECUTION_ROLE_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD,
            LAST_MODIFIED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusReason;

    private final String clusterName;

    private final String clusterType;

    private final String clusterDescription;

    private final String releaseLabel;

    private final List<Volume> volumes;

    private final String initializationScript;

    private final String executionRole;

    private final String azMode;

    private final String availabilityZoneId;

    private final Instant lastModifiedTimestamp;

    private final Instant createdTimestamp;

    private KxCluster(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.clusterName = builder.clusterName;
        this.clusterType = builder.clusterType;
        this.clusterDescription = builder.clusterDescription;
        this.releaseLabel = builder.releaseLabel;
        this.volumes = builder.volumes;
        this.initializationScript = builder.initializationScript;
        this.executionRole = builder.executionRole;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The status of a cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING –The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED– The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING –The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED– The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final KxClusterStatus status() {
        return KxClusterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING – The cluster is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATING –The cluster creation process is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED– The cluster creation process has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING – The cluster creation process is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The cluster is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The cluster is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The cluster has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The cluster failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING – The cluster is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATING –The cluster creation process is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED– The cluster creation process has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING – The cluster creation process is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The cluster is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The cluster is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The cluster has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The cluster failed to delete.
     *         </p>
     *         </li>
     * @see KxClusterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message when a failed state occurs.
     * </p>
     * 
     * @return The error message when a failed state occurs.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * A unique name for the cluster.
     * </p>
     * 
     * @return A unique name for the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * <li>
     * <p>
     * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
     * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
     * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not
     * support autoscaling and supports only <code>SINGLE</code> AZ mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
     * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log,
     * which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GP – A general purpose cluster allows you to quickly iterate on code during development by granting
     *         greater access to system commands and enabling a fast reload of custom code. This cluster type can
     *         optionally mount databases including cache and savedown storage. For this cluster type, the node count is
     *         fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It
     *         can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
     *         messages to log, which is readable by any RDB environment. It supports only single-node that is only one
     *         kdb process.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(clusterType);
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * <li>
     * <p>
     * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
     * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
     * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not
     * support autoscaling and supports only <code>SINGLE</code> AZ mode.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
     * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log,
     * which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GP – A general purpose cluster allows you to quickly iterate on code during development by granting
     *         greater access to system commands and enabling a fast reload of custom code. This cluster type can
     *         optionally mount databases including cache and savedown storage. For this cluster type, the node count is
     *         fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It
     *         can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
     *         messages to log, which is readable by any RDB environment. It supports only single-node that is only one
     *         kdb process.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * <p>
     * A description of the cluster.
     * </p>
     * 
     * @return A description of the cluster.
     */
    public final String clusterDescription() {
        return clusterDescription;
    }

    /**
     * <p>
     * A version of the FinSpace managed kdb to run.
     * </p>
     * 
     * @return A version of the FinSpace managed kdb to run.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of volumes attached to the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return A list of volumes attached to the cluster.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    /**
     * <p>
     * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that
     * contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example,
     * <code>somedir/init.q</code>.
     * </p>
     * 
     * @return Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i>
     *         file that contains the custom code, which will be loaded on the cluster. It must include the file name
     *         itself. For example, <code>somedir/init.q</code>.
     */
    public final String initializationScript() {
        return initializationScript;
    }

    /**
     * <p>
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a
     * cluster attempts to access another cluster.
     * </p>
     * 
     * @return An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed
     *         when a cluster attempts to access another cluster.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The number of availability zones assigned per cluster. This can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> – Assigns one availability zone per cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI</code> – Assigns all the availability zones per cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones assigned per cluster. This can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> – Assigns one availability zone per cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI</code> – Assigns all the availability zones per cluster.
     *         </p>
     *         </li>
     * @see KxAzMode
     */
    public final KxAzMode azMode() {
        return KxAzMode.fromValue(azMode);
    }

    /**
     * <p>
     * The number of availability zones assigned per cluster. This can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> – Assigns one availability zone per cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI</code> – Assigns all the availability zones per cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link KxAzMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return The number of availability zones assigned per cluster. This can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> – Assigns one availability zone per cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI</code> – Assigns all the availability zones per cluster.
     *         </p>
     *         </li>
     * @see KxAzMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The availability zone identifiers for the requested regions.
     * </p>
     * 
     * @return The availability zone identifiers for the requested regions.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxCluster)) {
            return false;
        }
        KxCluster other = (KxCluster) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(clusterDescription(), other.clusterDescription())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes())
                && Objects.equals(initializationScript(), other.initializationScript())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxCluster").add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("ClusterName", clusterName()).add("ClusterType", clusterTypeAsString())
                .add("ClusterDescription", clusterDescription()).add("ReleaseLabel", releaseLabel())
                .add("Volumes", hasVolumes() ? volumes() : null).add("InitializationScript", initializationScript())
                .add("ExecutionRole", executionRole()).add("AzMode", azModeAsString())
                .add("AvailabilityZoneId", availabilityZoneId()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "clusterDescription":
            return Optional.ofNullable(clazz.cast(clusterDescription()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "initializationScript":
            return Optional.ofNullable(clazz.cast(initializationScript()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "azMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("clusterDescription", CLUSTER_DESCRIPTION_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("volumes", VOLUMES_FIELD);
        map.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxCluster, T> g) {
        return obj -> g.apply((KxCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxCluster> {
        /**
         * <p>
         * The status of a cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING –The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED– The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING –The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED– The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING – The cluster is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATING –The cluster creation process is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED– The cluster creation process has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING – The cluster creation process is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The cluster is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The cluster is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The cluster has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The cluster failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING – The cluster is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATING –The cluster creation process is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED– The cluster creation process has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING – The cluster creation process is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The cluster is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The cluster is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The cluster has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The cluster failed to delete.
         *        </p>
         *        </li>
         * @see KxClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterStatus
         */
        Builder status(KxClusterStatus status);

        /**
         * <p>
         * The error message when a failed state occurs.
         * </p>
         * 
         * @param statusReason
         *        The error message when a failed state occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A unique name for the cluster.
         * </p>
         * 
         * @param clusterName
         *        A unique name for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * <li>
         * <p>
         * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
         * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
         * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does
         * not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
         * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to
         * log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GP – A general purpose cluster allows you to quickly iterate on code during development by granting
         *        greater access to system commands and enabling a fast reload of custom code. This cluster type can
         *        optionally mount databases including cache and savedown storage. For this cluster type, the node count
         *        is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions.
         *        It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
         *        messages to log, which is readable by any RDB environment. It supports only single-node that is only
         *        one kdb process.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * <li>
         * <p>
         * GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater
         * access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount
         * databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does
         * not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can
         * publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to
         * log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GP – A general purpose cluster allows you to quickly iterate on code during development by granting
         *        greater access to system commands and enabling a fast reload of custom code. This cluster type can
         *        optionally mount databases including cache and savedown storage. For this cluster type, the node count
         *        is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions.
         *        It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist
         *        messages to log, which is readable by any RDB environment. It supports only single-node that is only
         *        one kdb process.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(KxClusterType clusterType);

        /**
         * <p>
         * A description of the cluster.
         * </p>
         * 
         * @param clusterDescription
         *        A description of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDescription(String clusterDescription);

        /**
         * <p>
         * A version of the FinSpace managed kdb to run.
         * </p>
         * 
         * @param releaseLabel
         *        A version of the FinSpace managed kdb to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * 
         * @param volumes
         *        A list of volumes attached to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * 
         * @param volumes
         *        A list of volumes attached to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * A list of volumes attached to the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.Volume.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.Volume.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);

        /**
         * <p>
         * Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file
         * that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For
         * example, <code>somedir/init.q</code>.
         * </p>
         * 
         * @param initializationScript
         *        Specifies a Q program that will be run at launch of a cluster. It is a relative path within
         *        <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include
         *        the file name itself. For example, <code>somedir/init.q</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScript(String initializationScript);

        /**
         * <p>
         * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a
         * cluster attempts to access another cluster.
         * </p>
         * 
         * @param executionRole
         *        An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed
         *        when a cluster attempts to access another cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The number of availability zones assigned per cluster. This can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> – Assigns one availability zone per cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI</code> – Assigns all the availability zones per cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param azMode
         *        The number of availability zones assigned per cluster. This can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> – Assigns one availability zone per cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI</code> – Assigns all the availability zones per cluster.
         *        </p>
         *        </li>
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * The number of availability zones assigned per cluster. This can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> – Assigns one availability zone per cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI</code> – Assigns all the availability zones per cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param azMode
         *        The number of availability zones assigned per cluster. This can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> – Assigns one availability zone per cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI</code> – Assigns all the availability zones per cluster.
         *        </p>
         *        </li>
         * @see KxAzMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxAzMode
         */
        Builder azMode(KxAzMode azMode);

        /**
         * <p>
         * The availability zone identifiers for the requested regions.
         * </p>
         * 
         * @param availabilityZoneId
         *        The availability zone identifiers for the requested regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the cluster was modified. The value is determined as epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private String clusterName;

        private String clusterType;

        private String clusterDescription;

        private String releaseLabel;

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private String initializationScript;

        private String executionRole;

        private String azMode;

        private String availabilityZoneId;

        private Instant lastModifiedTimestamp;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxCluster model) {
            status(model.status);
            statusReason(model.statusReason);
            clusterName(model.clusterName);
            clusterType(model.clusterType);
            clusterDescription(model.clusterDescription);
            releaseLabel(model.releaseLabel);
            volumes(model.volumes);
            initializationScript(model.initializationScript);
            executionRole(model.executionRole);
            azMode(model.azMode);
            availabilityZoneId(model.availabilityZoneId);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterDescription() {
            return clusterDescription;
        }

        public final void setClusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
        }

        @Override
        public final Builder clusterDescription(String clusterDescription) {
            this.clusterDescription = clusterDescription;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitializationScript() {
            return initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public KxCluster build() {
            return new KxCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
