/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that stores metadata for a kdb node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxNode implements SdkPojo, Serializable, ToCopyableBuilder<KxNode.Builder, KxNode> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nodeId")
            .getter(getter(KxNode::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(KxNode::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("launchTime").getter(getter(KxNode::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KxNode::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, LAUNCH_TIME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeId;

    private final String availabilityZoneId;

    private final Instant launchTime;

    private final String status;

    private KxNode(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.launchTime = builder.launchTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique identifier for the node.
     * </p>
     * 
     * @return A unique identifier for the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The identifier of the availability zones where subnets for the environment are created.
     * </p>
     * 
     * @return The identifier of the availability zones where subnets for the environment are created.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The time when a particular node is started. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The time when a particular node is started. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * Specifies the status of the cluster nodes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> – The node is actively serving.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING</code> – The node is being prepared.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxNodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the cluster nodes. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – The node is actively serving.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> – The node is being prepared.
     *         </p>
     *         </li>
     * @see KxNodeStatus
     */
    public final KxNodeStatus status() {
        return KxNodeStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the status of the cluster nodes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> – The node is actively serving.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING</code> – The node is being prepared.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxNodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the cluster nodes. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – The node is actively serving.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> – The node is being prepared.
     *         </p>
     *         </li>
     * @see KxNodeStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxNode)) {
            return false;
        }
        KxNode other = (KxNode) obj;
        return Objects.equals(nodeId(), other.nodeId()) && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxNode").add("NodeId", nodeId()).add("AvailabilityZoneId", availabilityZoneId())
                .add("LaunchTime", launchTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "launchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeId", NODE_ID_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("launchTime", LAUNCH_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxNode, T> g) {
        return obj -> g.apply((KxNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxNode> {
        /**
         * <p>
         * A unique identifier for the node.
         * </p>
         * 
         * @param nodeId
         *        A unique identifier for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The identifier of the availability zones where subnets for the environment are created.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the availability zones where subnets for the environment are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The time when a particular node is started. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param launchTime
         *        The time when a particular node is started. The value is determined as epoch time in milliseconds. For
         *        example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * Specifies the status of the cluster nodes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> – The node is actively serving.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING</code> – The node is being prepared.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Specifies the status of the cluster nodes. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – The node is actively serving.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> – The node is being prepared.
         *        </p>
         *        </li>
         * @see KxNodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxNodeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the status of the cluster nodes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> – The node is actively serving.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING</code> – The node is being prepared.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Specifies the status of the cluster nodes. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – The node is actively serving.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> – The node is being prepared.
         *        </p>
         *        </li>
         * @see KxNodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxNodeStatus
         */
        Builder status(KxNodeStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String nodeId;

        private String availabilityZoneId;

        private Instant launchTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(KxNode model) {
            nodeId(model.nodeId);
            availabilityZoneId(model.availabilityZoneId);
            launchTime(model.launchTime);
            status(model.status);
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxNodeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public KxNode build() {
            return new KxNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
