/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKxClusterNodesResponse extends FinspaceResponse implements
        ToCopyableBuilder<ListKxClusterNodesResponse.Builder, ListKxClusterNodesResponse> {
    private static final SdkField<List<KxNode>> NODES_FIELD = SdkField
            .<List<KxNode>> builder(MarshallingType.LIST)
            .memberName("nodes")
            .getter(getter(ListKxClusterNodesResponse::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListKxClusterNodesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NODES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<KxNode> nodes;

    private final String nextToken;

    private ListKxClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nodes = builder.nodes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of nodes associated with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodes} method.
     * </p>
     * 
     * @return A list of nodes associated with the cluster.
     */
    public final List<KxNode> nodes() {
        return nodes;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxClusterNodesResponse)) {
            return false;
        }
        ListKxClusterNodesResponse other = (ListKxClusterNodesResponse) obj;
        return hasNodes() == other.hasNodes() && Objects.equals(nodes(), other.nodes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKxClusterNodesResponse").add("Nodes", hasNodes() ? nodes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodes", NODES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKxClusterNodesResponse, T> g) {
        return obj -> g.apply((ListKxClusterNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKxClusterNodesResponse> {
        /**
         * <p>
         * A list of nodes associated with the cluster.
         * </p>
         * 
         * @param nodes
         *        A list of nodes associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<KxNode> nodes);

        /**
         * <p>
         * A list of nodes associated with the cluster.
         * </p>
         * 
         * @param nodes
         *        A list of nodes associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(KxNode... nodes);

        /**
         * <p>
         * A list of nodes associated with the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxNode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.KxNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxNode.Builder#build()} is called immediately and its
         * result is passed to {@link #nodes(List<KxNode>)}.
         * 
         * @param nodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodes(java.util.Collection<KxNode>)
         */
        Builder nodes(Consumer<KxNode.Builder>... nodes);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private List<KxNode> nodes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxClusterNodesResponse model) {
            super(model);
            nodes(model.nodes);
            nextToken(model.nextToken);
        }

        public final List<KxNode.Builder> getNodes() {
            List<KxNode.Builder> result = KxNodeSummariesCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<KxNode.BuilderImpl> nodes) {
            this.nodes = KxNodeSummariesCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<KxNode> nodes) {
            this.nodes = KxNodeSummariesCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(KxNode... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<KxNode.Builder>... nodes) {
            nodes(Stream.of(nodes).map(c -> KxNode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxClusterNodesResponse build() {
            return new ListKxClusterNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
