/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of the transit gateway and network configuration that is used to connect the kdb environment to an
 * internal network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConfiguration.Builder, TransitGatewayConfiguration> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transitGatewayID").getter(getter(TransitGatewayConfiguration::transitGatewayID))
            .setter(setter(Builder::transitGatewayID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayID").build()).build();

    private static final SdkField<String> ROUTABLE_CIDR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("routableCIDRSpace").getter(getter(TransitGatewayConfiguration::routableCIDRSpace))
            .setter(setter(Builder::routableCIDRSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routableCIDRSpace").build()).build();

    private static final SdkField<List<NetworkACLEntry>> ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD = SdkField
            .<List<NetworkACLEntry>> builder(MarshallingType.LIST)
            .memberName("attachmentNetworkAclConfiguration")
            .getter(getter(TransitGatewayConfiguration::attachmentNetworkAclConfiguration))
            .setter(setter(Builder::attachmentNetworkAclConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentNetworkAclConfiguration")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkACLEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkACLEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD,
            ROUTABLE_CIDR_SPACE_FIELD, ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayID;

    private final String routableCIDRSpace;

    private final List<NetworkACLEntry> attachmentNetworkAclConfiguration;

    private TransitGatewayConfiguration(BuilderImpl builder) {
        this.transitGatewayID = builder.transitGatewayID;
        this.routableCIDRSpace = builder.routableCIDRSpace;
        this.attachmentNetworkAclConfiguration = builder.attachmentNetworkAclConfiguration;
    }

    /**
     * <p>
     * The identifier of the transit gateway created by the customer to connect outbound traffics from kdb network to
     * your internal network.
     * </p>
     * 
     * @return The identifier of the transit gateway created by the customer to connect outbound traffics from kdb
     *         network to your internal network.
     */
    public final String transitGatewayID() {
        return transitGatewayID;
    }

    /**
     * <p>
     * The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space. After
     * providing, it will be added to the customer's transit gateway routing table so that the traffics could be routed
     * to kdb network.
     * </p>
     * 
     * @return The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space.
     *         After providing, it will be added to the customer's transit gateway routing table so that the traffics
     *         could be routed to kdb network.
     */
    public final String routableCIDRSpace() {
        return routableCIDRSpace;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachmentNetworkAclConfiguration
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAttachmentNetworkAclConfiguration() {
        return attachmentNetworkAclConfiguration != null && !(attachmentNetworkAclConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules that define how you manage the outbound traffic from kdb network to your internal network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachmentNetworkAclConfiguration}
     * method.
     * </p>
     * 
     * @return The rules that define how you manage the outbound traffic from kdb network to your internal network.
     */
    public final List<NetworkACLEntry> attachmentNetworkAclConfiguration() {
        return attachmentNetworkAclConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayID());
        hashCode = 31 * hashCode + Objects.hashCode(routableCIDRSpace());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAttachmentNetworkAclConfiguration() ? attachmentNetworkAclConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConfiguration)) {
            return false;
        }
        TransitGatewayConfiguration other = (TransitGatewayConfiguration) obj;
        return Objects.equals(transitGatewayID(), other.transitGatewayID())
                && Objects.equals(routableCIDRSpace(), other.routableCIDRSpace())
                && hasAttachmentNetworkAclConfiguration() == other.hasAttachmentNetworkAclConfiguration()
                && Objects.equals(attachmentNetworkAclConfiguration(), other.attachmentNetworkAclConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TransitGatewayConfiguration")
                .add("TransitGatewayID", transitGatewayID())
                .add("RoutableCIDRSpace", routableCIDRSpace())
                .add("AttachmentNetworkAclConfiguration",
                        hasAttachmentNetworkAclConfiguration() ? attachmentNetworkAclConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transitGatewayID":
            return Optional.ofNullable(clazz.cast(transitGatewayID()));
        case "routableCIDRSpace":
            return Optional.ofNullable(clazz.cast(routableCIDRSpace()));
        case "attachmentNetworkAclConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentNetworkAclConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transitGatewayID", TRANSIT_GATEWAY_ID_FIELD);
        map.put("routableCIDRSpace", ROUTABLE_CIDR_SPACE_FIELD);
        map.put("attachmentNetworkAclConfiguration", ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConfiguration> {
        /**
         * <p>
         * The identifier of the transit gateway created by the customer to connect outbound traffics from kdb network
         * to your internal network.
         * </p>
         * 
         * @param transitGatewayID
         *        The identifier of the transit gateway created by the customer to connect outbound traffics from kdb
         *        network to your internal network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayID(String transitGatewayID);

        /**
         * <p>
         * The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space. After
         * providing, it will be added to the customer's transit gateway routing table so that the traffics could be
         * routed to kdb network.
         * </p>
         * 
         * @param routableCIDRSpace
         *        The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR
         *        space. After providing, it will be added to the customer's transit gateway routing table so that the
         *        traffics could be routed to kdb network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routableCIDRSpace(String routableCIDRSpace);

        /**
         * <p>
         * The rules that define how you manage the outbound traffic from kdb network to your internal network.
         * </p>
         * 
         * @param attachmentNetworkAclConfiguration
         *        The rules that define how you manage the outbound traffic from kdb network to your internal network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentNetworkAclConfiguration(Collection<NetworkACLEntry> attachmentNetworkAclConfiguration);

        /**
         * <p>
         * The rules that define how you manage the outbound traffic from kdb network to your internal network.
         * </p>
         * 
         * @param attachmentNetworkAclConfiguration
         *        The rules that define how you manage the outbound traffic from kdb network to your internal network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentNetworkAclConfiguration(NetworkACLEntry... attachmentNetworkAclConfiguration);

        /**
         * <p>
         * The rules that define how you manage the outbound traffic from kdb network to your internal network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.NetworkACLEntry.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.finspace.model.NetworkACLEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.NetworkACLEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentNetworkAclConfiguration(List<NetworkACLEntry>)}.
         * 
         * @param attachmentNetworkAclConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.NetworkACLEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentNetworkAclConfiguration(java.util.Collection<NetworkACLEntry>)
         */
        Builder attachmentNetworkAclConfiguration(Consumer<NetworkACLEntry.Builder>... attachmentNetworkAclConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayID;

        private String routableCIDRSpace;

        private List<NetworkACLEntry> attachmentNetworkAclConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConfiguration model) {
            transitGatewayID(model.transitGatewayID);
            routableCIDRSpace(model.routableCIDRSpace);
            attachmentNetworkAclConfiguration(model.attachmentNetworkAclConfiguration);
        }

        public final String getTransitGatewayID() {
            return transitGatewayID;
        }

        public final void setTransitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
        }

        @Override
        public final Builder transitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
            return this;
        }

        public final String getRoutableCIDRSpace() {
            return routableCIDRSpace;
        }

        public final void setRoutableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
        }

        @Override
        public final Builder routableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
            return this;
        }

        public final List<NetworkACLEntry.Builder> getAttachmentNetworkAclConfiguration() {
            List<NetworkACLEntry.Builder> result = NetworkACLConfigurationCopier
                    .copyToBuilder(this.attachmentNetworkAclConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentNetworkAclConfiguration(
                Collection<NetworkACLEntry.BuilderImpl> attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration = NetworkACLConfigurationCopier
                    .copyFromBuilder(attachmentNetworkAclConfiguration);
        }

        @Override
        public final Builder attachmentNetworkAclConfiguration(Collection<NetworkACLEntry> attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration = NetworkACLConfigurationCopier.copy(attachmentNetworkAclConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentNetworkAclConfiguration(NetworkACLEntry... attachmentNetworkAclConfiguration) {
            attachmentNetworkAclConfiguration(Arrays.asList(attachmentNetworkAclConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentNetworkAclConfiguration(
                Consumer<NetworkACLEntry.Builder>... attachmentNetworkAclConfiguration) {
            attachmentNetworkAclConfiguration(Stream.of(attachmentNetworkAclConfiguration)
                    .map(c -> NetworkACLEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayConfiguration build() {
            return new TransitGatewayConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
