/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKxClusterDatabasesRequest extends FinspaceRequest implements
        ToCopyableBuilder<UpdateKxClusterDatabasesRequest.Builder, UpdateKxClusterDatabasesRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateKxClusterDatabasesRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateKxClusterDatabasesRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateKxClusterDatabasesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<KxDatabaseConfiguration>> DATABASES_FIELD = SdkField
            .<List<KxDatabaseConfiguration>> builder(MarshallingType.LIST)
            .memberName("databases")
            .getter(getter(UpdateKxClusterDatabasesRequest::databases))
            .setter(setter(Builder::databases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDatabaseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDatabaseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KxDeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<KxDeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(UpdateKxClusterDatabasesRequest::deploymentConfiguration))
            .setter(setter(Builder::deploymentConfiguration)).constructor(KxDeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            CLUSTER_NAME_FIELD, CLIENT_TOKEN_FIELD, DATABASES_FIELD, DEPLOYMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String clusterName;

    private final String clientToken;

    private final List<KxDatabaseConfiguration> databases;

    private final KxDeploymentConfiguration deploymentConfiguration;

    private UpdateKxClusterDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.databases = builder.databases;
        this.deploymentConfiguration = builder.deploymentConfiguration;
    }

    /**
     * <p>
     * The unique identifier of a kdb environment.
     * </p>
     * 
     * @return The unique identifier of a kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A unique name for the cluster that you want to modify.
     * </p>
     * 
     * @return A unique name for the cluster that you want to modify.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Databases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatabases() {
        return databases != null && !(databases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The structure of databases mounted on the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabases} method.
     * </p>
     * 
     * @return The structure of databases mounted on the cluster.
     */
    public final List<KxDatabaseConfiguration> databases() {
        return databases;
    }

    /**
     * <p>
     * The configuration that allows you to choose how you want to update the databases on a cluster.
     * </p>
     * 
     * @return The configuration that allows you to choose how you want to update the databases on a cluster.
     */
    public final KxDeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabases() ? databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxClusterDatabasesRequest)) {
            return false;
        }
        UpdateKxClusterDatabasesRequest other = (UpdateKxClusterDatabasesRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clientToken(), other.clientToken()) && hasDatabases() == other.hasDatabases()
                && Objects.equals(databases(), other.databases())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKxClusterDatabasesRequest").add("EnvironmentId", environmentId())
                .add("ClusterName", clusterName()).add("ClientToken", clientToken())
                .add("Databases", hasDatabases() ? databases() : null).add("DeploymentConfiguration", deploymentConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "databases":
            return Optional.ofNullable(clazz.cast(databases()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("databases", DATABASES_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxClusterDatabasesRequest, T> g) {
        return obj -> g.apply((UpdateKxClusterDatabasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKxClusterDatabasesRequest> {
        /**
         * <p>
         * The unique identifier of a kdb environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of a kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A unique name for the cluster that you want to modify.
         * </p>
         * 
         * @param clusterName
         *        A unique name for the cluster that you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The structure of databases mounted on the cluster.
         * </p>
         * 
         * @param databases
         *        The structure of databases mounted on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(Collection<KxDatabaseConfiguration> databases);

        /**
         * <p>
         * The structure of databases mounted on the cluster.
         * </p>
         * 
         * @param databases
         *        The structure of databases mounted on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(KxDatabaseConfiguration... databases);

        /**
         * <p>
         * The structure of databases mounted on the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #databases(List<KxDatabaseConfiguration>)}.
         * 
         * @param databases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databases(java.util.Collection<KxDatabaseConfiguration>)
         */
        Builder databases(Consumer<KxDatabaseConfiguration.Builder>... databases);

        /**
         * <p>
         * The configuration that allows you to choose how you want to update the databases on a cluster.
         * </p>
         * 
         * @param deploymentConfiguration
         *        The configuration that allows you to choose how you want to update the databases on a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(KxDeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * The configuration that allows you to choose how you want to update the databases on a cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link KxDeploymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link KxDeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxDeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(KxDeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link KxDeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(KxDeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<KxDeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(KxDeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String clusterName;

        private String clientToken;

        private List<KxDatabaseConfiguration> databases = DefaultSdkAutoConstructList.getInstance();

        private KxDeploymentConfiguration deploymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxClusterDatabasesRequest model) {
            super(model);
            environmentId(model.environmentId);
            clusterName(model.clusterName);
            clientToken(model.clientToken);
            databases(model.databases);
            deploymentConfiguration(model.deploymentConfiguration);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<KxDatabaseConfiguration.Builder> getDatabases() {
            List<KxDatabaseConfiguration.Builder> result = KxDatabaseConfigurationsCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<KxDatabaseConfiguration.BuilderImpl> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<KxDatabaseConfiguration> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(KxDatabaseConfiguration... databases) {
            databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<KxDatabaseConfiguration.Builder>... databases) {
            databases(Stream.of(databases).map(c -> KxDatabaseConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final KxDeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(KxDeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(KxDeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxClusterDatabasesRequest build() {
            return new UpdateKxClusterDatabasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
