/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChangesetRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<CreateChangesetRequest.Builder, CreateChangesetRequest> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(CreateChangesetRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(CreateChangesetRequest::changeTypeAsString))
            .setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(CreateChangesetRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sourceParams")
            .getter(getter(CreateChangesetRequest::sourceParams))
            .setter(setter(Builder::sourceParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formatType").getter(getter(CreateChangesetRequest::formatTypeAsString))
            .setter(setter(Builder::formatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatType").build()).build();

    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("formatParams")
            .getter(getter(CreateChangesetRequest::formatParams))
            .setter(setter(Builder::formatParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateChangesetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            CHANGE_TYPE_FIELD, SOURCE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_TYPE_FIELD, FORMAT_PARAMS_FIELD, TAGS_FIELD));

    private final String datasetId;

    private final String changeType;

    private final String sourceType;

    private final Map<String, String> sourceParams;

    private final String formatType;

    private final Map<String, String> formatParams;

    private final Map<String, String> tags;

    private CreateChangesetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceType = builder.sourceType;
        this.sourceParams = builder.sourceParams;
        this.formatType = builder.formatType;
        this.formatParams = builder.formatParams;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the FinSpace dataset in which the changeset will be created.
     * </p>
     * 
     * @return The unique identifier for the FinSpace dataset in which the changeset will be created.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * Option to indicate how a changeset will be applied to a dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded changesets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Option to indicate how a changeset will be applied to a dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded
     *         changesets.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Option to indicate how a changeset will be applied to a dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded changesets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Option to indicate how a changeset will be applied to a dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded
     *         changesets.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    /**
     * <p>
     * Type of the data source from which the files to create the changeset will be sourced.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code> - Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Type of the data source from which the files to create the changeset will be sourced.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code> - Amazon S3.
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Type of the data source from which the files to create the changeset will be sourced.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code> - Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Type of the data source from which the files to create the changeset will be sourced.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code> - Amazon S3.
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * Returns true if the SourceParams property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSourceParams() {
        return sourceParams != null && !(sourceParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Source path from which the files to create the changeset will be sourced.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceParams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Source path from which the files to create the changeset will be sourced.
     */
    public final Map<String, String> sourceParams() {
        return sourceParams;
    }

    /**
     * <p>
     * Format type of the input files being loaded into the changeset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link FormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatTypeAsString}.
     * </p>
     * 
     * @return Format type of the input files being loaded into the changeset.
     * @see FormatType
     */
    public final FormatType formatType() {
        return FormatType.fromValue(formatType);
    }

    /**
     * <p>
     * Format type of the input files being loaded into the changeset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link FormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatTypeAsString}.
     * </p>
     * 
     * @return Format type of the input files being loaded into the changeset.
     * @see FormatType
     */
    public final String formatTypeAsString() {
        return formatType;
    }

    /**
     * Returns true if the FormatParams property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFormatParams() {
        return formatParams != null && !(formatParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Options that define the structure of the source file(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFormatParams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Options that define the structure of the source file(s).
     */
    public final Map<String, String> formatParams() {
        return formatParams;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags to apply to this changeset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags to apply to this changeset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceParams() ? sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatParams() ? formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangesetRequest)) {
            return false;
        }
        CreateChangesetRequest other = (CreateChangesetRequest) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(changeTypeAsString(), other.changeTypeAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && hasSourceParams() == other.hasSourceParams() && Objects.equals(sourceParams(), other.sourceParams())
                && Objects.equals(formatTypeAsString(), other.formatTypeAsString())
                && hasFormatParams() == other.hasFormatParams() && Objects.equals(formatParams(), other.formatParams())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChangesetRequest").add("DatasetId", datasetId()).add("ChangeType", changeTypeAsString())
                .add("SourceType", sourceTypeAsString()).add("SourceParams", hasSourceParams() ? sourceParams() : null)
                .add("FormatType", formatTypeAsString()).add("FormatParams", hasFormatParams() ? formatParams() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "sourceParams":
            return Optional.ofNullable(clazz.cast(sourceParams()));
        case "formatType":
            return Optional.ofNullable(clazz.cast(formatTypeAsString()));
        case "formatParams":
            return Optional.ofNullable(clazz.cast(formatParams()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChangesetRequest, T> g) {
        return obj -> g.apply((CreateChangesetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChangesetRequest> {
        /**
         * <p>
         * The unique identifier for the FinSpace dataset in which the changeset will be created.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the FinSpace dataset in which the changeset will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * Option to indicate how a changeset will be applied to a dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded changesets.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Option to indicate how a changeset will be applied to a dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded
         *        changesets.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Option to indicate how a changeset will be applied to a dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded changesets.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Option to indicate how a changeset will be applied to a dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset will be considered as a replacement to all prior loaded changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset will be considered as an addition to the end of all prior loaded
         *        changesets.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);

        /**
         * <p>
         * Type of the data source from which the files to create the changeset will be sourced.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code> - Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        Type of the data source from which the files to create the changeset will be sourced.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code> - Amazon S3.
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Type of the data source from which the files to create the changeset will be sourced.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code> - Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        Type of the data source from which the files to create the changeset will be sourced.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code> - Amazon S3.
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * <p>
         * Source path from which the files to create the changeset will be sourced.
         * </p>
         * 
         * @param sourceParams
         *        Source path from which the files to create the changeset will be sourced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParams(Map<String, String> sourceParams);

        /**
         * <p>
         * Format type of the input files being loaded into the changeset.
         * </p>
         * 
         * @param formatType
         *        Format type of the input files being loaded into the changeset.
         * @see FormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatType
         */
        Builder formatType(String formatType);

        /**
         * <p>
         * Format type of the input files being loaded into the changeset.
         * </p>
         * 
         * @param formatType
         *        Format type of the input files being loaded into the changeset.
         * @see FormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatType
         */
        Builder formatType(FormatType formatType);

        /**
         * <p>
         * Options that define the structure of the source file(s).
         * </p>
         * 
         * @param formatParams
         *        Options that define the structure of the source file(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatParams(Map<String, String> formatParams);

        /**
         * <p>
         * Metadata tags to apply to this changeset.
         * </p>
         * 
         * @param tags
         *        Metadata tags to apply to this changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String datasetId;

        private String changeType;

        private String sourceType;

        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();

        private String formatType;

        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangesetRequest model) {
            super(model);
            datasetId(model.datasetId);
            changeType(model.changeType);
            sourceType(model.sourceType);
            sourceParams(model.sourceParams);
            formatType(model.formatType);
            formatParams(model.formatParams);
            tags(model.tags);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        public final String getChangeType() {
            return changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Map<String, String> getSourceParams() {
            if (sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceParams;
        }

        @Override
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
            return this;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
        }

        public final String getFormatType() {
            return formatType;
        }

        @Override
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        public final Builder formatType(FormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        public final Map<String, String> getFormatParams() {
            if (formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatParams;
        }

        @Override
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
            return this;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChangesetRequest build() {
            return new CreateChangesetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
