/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChangesetResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<CreateChangesetResponse.Builder, CreateChangesetResponse> {
    private static final SdkField<ChangesetInfo> CHANGESET_FIELD = SdkField.<ChangesetInfo> builder(MarshallingType.SDK_POJO)
            .memberName("changeset").getter(getter(CreateChangesetResponse::changeset)).setter(setter(Builder::changeset))
            .constructor(ChangesetInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_FIELD));

    private final ChangesetInfo changeset;

    private CreateChangesetResponse(BuilderImpl builder) {
        super(builder);
        this.changeset = builder.changeset;
    }

    /**
     * <p>
     * Returns the changeset details.
     * </p>
     * 
     * @return Returns the changeset details.
     */
    public final ChangesetInfo changeset() {
        return changeset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangesetResponse)) {
            return false;
        }
        CreateChangesetResponse other = (CreateChangesetResponse) obj;
        return Objects.equals(changeset(), other.changeset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChangesetResponse").add("Changeset", changeset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changeset":
            return Optional.ofNullable(clazz.cast(changeset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChangesetResponse, T> g) {
        return obj -> g.apply((CreateChangesetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChangesetResponse> {
        /**
         * <p>
         * Returns the changeset details.
         * </p>
         * 
         * @param changeset
         *        Returns the changeset details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeset(ChangesetInfo changeset);

        /**
         * <p>
         * Returns the changeset details.
         * </p>
         * This is a convenience that creates an instance of the {@link ChangesetInfo.Builder} avoiding the need to
         * create one manually via {@link ChangesetInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangesetInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #changeset(ChangesetInfo)}.
         * 
         * @param changeset
         *        a consumer that will call methods on {@link ChangesetInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeset(ChangesetInfo)
         */
        default Builder changeset(Consumer<ChangesetInfo.Builder> changeset) {
            return changeset(ChangesetInfo.builder().applyMutation(changeset).build());
        }
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private ChangesetInfo changeset;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangesetResponse model) {
            super(model);
            changeset(model.changeset);
        }

        public final ChangesetInfo.Builder getChangeset() {
            return changeset != null ? changeset.toBuilder() : null;
        }

        @Override
        public final Builder changeset(ChangesetInfo changeset) {
            this.changeset = changeset;
            return this;
        }

        public final void setChangeset(ChangesetInfo.BuilderImpl changeset) {
            this.changeset = changeset != null ? changeset.build() : null;
        }

        @Override
        public CreateChangesetResponse build() {
            return new CreateChangesetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
