/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ErrorInfo.Builder, ErrorInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ErrorInfo::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCategory").getter(getter(ErrorInfo::errorCategoryAsString)).setter(setter(Builder::errorCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            ERROR_CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String errorCategory;

    private ErrorInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.errorCategory = builder.errorCategory;
    }

    /**
     * <p>
     * The text of the error message.
     * </p>
     * 
     * @return The text of the error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The category of the error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALIDATION</code> -The inputs to this request are invalid.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase
     * quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> - A user recoverable error has occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCategory}
     * will return {@link ErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCategoryAsString}.
     * </p>
     * 
     * @return The category of the error.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALIDATION</code> -The inputs to this request are invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
     *         increase quotas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> - A user recoverable error has occurred.
     *         </p>
     *         </li>
     * @see ErrorCategory
     */
    public final ErrorCategory errorCategory() {
        return ErrorCategory.fromValue(errorCategory);
    }

    /**
     * <p>
     * The category of the error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALIDATION</code> -The inputs to this request are invalid.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to increase
     * quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> - A user recoverable error has occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCategory}
     * will return {@link ErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCategoryAsString}.
     * </p>
     * 
     * @return The category of the error.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALIDATION</code> -The inputs to this request are invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
     *         increase quotas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> - A user recoverable error has occurred.
     *         </p>
     *         </li>
     * @see ErrorCategory
     */
    public final String errorCategoryAsString() {
        return errorCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo) obj;
        return Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCategoryAsString(), other.errorCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInfo").add("ErrorMessage", errorMessage()).add("ErrorCategory", errorCategoryAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorCategory":
            return Optional.ofNullable(clazz.cast(errorCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInfo> {
        /**
         * <p>
         * The text of the error message.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The category of the error.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALIDATION</code> -The inputs to this request are invalid.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
         * increase quotas.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> - A user recoverable error has occurred.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCategory
         *        The category of the error.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALIDATION</code> -The inputs to this request are invalid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
         *        increase quotas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> - A user recoverable error has occurred.
         *        </p>
         *        </li>
         * @see ErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCategory
         */
        Builder errorCategory(String errorCategory);

        /**
         * <p>
         * The category of the error.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALIDATION</code> -The inputs to this request are invalid.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
         * increase quotas.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> - A user recoverable error has occurred.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCategory
         *        The category of the error.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALIDATION</code> -The inputs to this request are invalid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_QUOTA_EXCEEDED</code> - Service quotas have been exceeded. Please contact AWS support to
         *        increase quotas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code> - Missing required permission to perform this request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE_NOT_FOUND</code> - One or more inputs to this request were not found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THROTTLING</code> - The system temporarily lacks sufficient resources to process the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_SERVICE_EXCEPTION</code> - An internal service error has occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> - A user recoverable error has occurred.
         *        </p>
         *        </li>
         * @see ErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCategory
         */
        Builder errorCategory(ErrorCategory errorCategory);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String errorCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            errorMessage(model.errorMessage);
            errorCategory(model.errorCategory);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCategory() {
            return errorCategory;
        }

        @Override
        public final Builder errorCategory(String errorCategory) {
            this.errorCategory = errorCategory;
            return this;
        }

        @Override
        public final Builder errorCategory(ErrorCategory errorCategory) {
            this.errorCategory(errorCategory == null ? null : errorCategory.toString());
            return this;
        }

        public final void setErrorCategory(String errorCategory) {
            this.errorCategory = errorCategory;
        }

        @Override
        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
