/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkingLocationResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetWorkingLocationResponse> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(GetWorkingLocationResponse.getter(GetWorkingLocationResponse::s3Uri)).setter(GetWorkingLocationResponse.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Path").getter(GetWorkingLocationResponse.getter(GetWorkingLocationResponse::s3Path)).setter(GetWorkingLocationResponse.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(GetWorkingLocationResponse.getter(GetWorkingLocationResponse::s3Bucket)).setter(GetWorkingLocationResponse.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, S3_PATH_FIELD, S3_BUCKET_FIELD));
    private final String s3Uri;
    private final String s3Path;
    private final String s3Bucket;

    private GetWorkingLocationResponse(BuilderImpl builder) {
        super(builder);
        this.s3Uri = builder.s3Uri;
        this.s3Path = builder.s3Path;
        this.s3Bucket = builder.s3Bucket;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String s3Path() {
        return this.s3Path;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkingLocationResponse)) {
            return false;
        }
        GetWorkingLocationResponse other = (GetWorkingLocationResponse)((Object)obj);
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.s3Bucket(), other.s3Bucket());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkingLocationResponse").add("S3Uri", (Object)this.s3Uri()).add("S3Path", (Object)this.s3Path()).add("S3Bucket", (Object)this.s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "s3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkingLocationResponse, T> g) {
        return obj -> g.apply((GetWorkingLocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String s3Uri;
        private String s3Path;
        private String s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkingLocationResponse model) {
            super(model);
            this.s3Uri(model.s3Uri);
            this.s3Path(model.s3Path);
            this.s3Bucket(model.s3Bucket);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public GetWorkingLocationResponse build() {
            return new GetWorkingLocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkingLocationResponse> {
        public Builder s3Uri(String var1);

        public Builder s3Path(String var1);

        public Builder s3Bucket(String var1);
    }
}

