/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the user account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(User::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(User::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstName").getter(getter(User::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastName").getter(getter(User::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(User::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(User::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> API_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccess").getter(getter(User::apiAccessAsString)).setter(setter(Builder::apiAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()).build();

    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccessPrincipalArn").getter(getter(User::apiAccessPrincipalArn))
            .setter(setter(Builder::apiAccessPrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build())
            .build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createTime").getter(getter(User::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Long> LAST_ENABLED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastEnabledTime").getter(getter(User::lastEnabledTime)).setter(setter(Builder::lastEnabledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEnabledTime").build()).build();

    private static final SdkField<Long> LAST_DISABLED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastDisabledTime").getter(getter(User::lastDisabledTime)).setter(setter(Builder::lastDisabledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDisabledTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(User::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<Long> LAST_LOGIN_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastLoginTime").getter(getter(User::lastLoginTime)).setter(setter(Builder::lastLoginTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLoginTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_ID_FIELD, STATUS_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, TYPE_FIELD,
                    API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD, CREATE_TIME_FIELD, LAST_ENABLED_TIME_FIELD,
                    LAST_DISABLED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_LOGIN_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String status;

    private final String firstName;

    private final String lastName;

    private final String emailAddress;

    private final String type;

    private final String apiAccess;

    private final String apiAccessPrincipalArn;

    private final Long createTime;

    private final Long lastEnabledTime;

    private final Long lastDisabledTime;

    private final Long lastModifiedTime;

    private final Long lastLoginTime;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.status = builder.status;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.createTime = builder.createTime;
        this.lastEnabledTime = builder.lastEnabledTime;
        this.lastDisabledTime = builder.lastDisabledTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastLoginTime = builder.lastLoginTime;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The current status of the user account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The user account creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user account is created and is currently active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user account is currently inactive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the user account. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The user account creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user account is created and is currently active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user account is currently inactive.
     *         </p>
     *         </li>
     * @see UserStatus
     */
    public final UserStatus status() {
        return UserStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the user account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The user account creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user account is created and is currently active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user account is currently inactive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the user account. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The user account creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user account is created and is currently active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user account is currently inactive.
     *         </p>
     *         </li>
     * @see UserStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The email address of the user. The email address serves as a uniquer identifier for each user and cannot be
     * changed after it's created.
     * </p>
     * 
     * @return The email address of the user. The email address serves as a uniquer identifier for each user and cannot
     *         be changed after it's created.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * Indicates the type of user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permissions group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permissions group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final UserType type() {
        return UserType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permissions group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permissions group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials
     * that can then be used to access other FinSpace Data API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the APIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any APIs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
     *         credentials that can then be used to access other FinSpace Data API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the APIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any APIs.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(apiAccess);
    }

    /**
     * <p>
     * Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain credentials
     * that can then be used to access other FinSpace Data API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the APIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any APIs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
     *         credentials that can then be used to access other FinSpace Data API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the APIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any APIs.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final String apiAccessAsString() {
        return apiAccess;
    }

    /**
     * <p>
     * The ARN identifier of an AWS user or role that is allowed to call the
     * <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user.
     * This must be an IAM role within your FinSpace account.
     * </p>
     * 
     * @return The ARN identifier of an AWS user or role that is allowed to call the
     *         <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace
     *         user. This must be an IAM role within your FinSpace account.
     */
    public final String apiAccessPrincipalArn() {
        return apiAccessPrincipalArn;
    }

    /**
     * <p>
     * The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in
     * milliseconds.
     * </p>
     * 
     * @return The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in
     *         milliseconds.
     */
    public final Long createTime() {
        return createTime;
    }

    /**
     * <p>
     * Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.
     * </p>
     * 
     * @return Describes the last time the user account was enabled. The value is determined as epoch time in
     *         milliseconds.
     */
    public final Long lastEnabledTime() {
        return lastEnabledTime;
    }

    /**
     * <p>
     * Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.
     * </p>
     * 
     * @return Describes the last time the user account was disabled. The value is determined as epoch time in
     *         milliseconds.
     */
    public final Long lastDisabledTime() {
        return lastDisabledTime;
    }

    /**
     * <p>
     * Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.
     * </p>
     * 
     * @return Describes the last time the user account was updated. The value is determined as epoch time in
     *         milliseconds.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Describes the last time that the user logged into their account. The value is determined as epoch time in
     * milliseconds.
     * </p>
     * 
     * @return Describes the last time that the user logged into their account. The value is determined as epoch time in
     *         milliseconds.
     */
    public final Long lastLoginTime() {
        return lastLoginTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastEnabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDisabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastLoginTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(apiAccessAsString(), other.apiAccessAsString())
                && Objects.equals(apiAccessPrincipalArn(), other.apiAccessPrincipalArn())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(lastEnabledTime(), other.lastEnabledTime())
                && Objects.equals(lastDisabledTime(), other.lastDisabledTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastLoginTime(), other.lastLoginTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("UserId", userId()).add("Status", statusAsString())
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("ApiAccess", apiAccessAsString())
                .add("ApiAccessPrincipalArn", apiAccessPrincipalArn()).add("CreateTime", createTime())
                .add("LastEnabledTime", lastEnabledTime()).add("LastDisabledTime", lastDisabledTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastLoginTime", lastLoginTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "firstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "lastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "apiAccess":
            return Optional.ofNullable(clazz.cast(apiAccessAsString()));
        case "apiAccessPrincipalArn":
            return Optional.ofNullable(clazz.cast(apiAccessPrincipalArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "lastEnabledTime":
            return Optional.ofNullable(clazz.cast(lastEnabledTime()));
        case "lastDisabledTime":
            return Optional.ofNullable(clazz.cast(lastDisabledTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "lastLoginTime":
            return Optional.ofNullable(clazz.cast(lastLoginTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The current status of the user account.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The user account creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user account is created and is currently active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user account is currently inactive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the user account. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The user account creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user account is created and is currently active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user account is currently inactive.
         *        </p>
         *        </li>
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the user account.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The user account creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user account is created and is currently active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user account is currently inactive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the user account. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The user account creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user account is created and is currently active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user account is currently inactive.
         *        </p>
         *        </li>
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder status(UserStatus status);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param firstName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param lastName
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The email address of the user. The email address serves as a uniquer identifier for each user and cannot be
         * changed after it's created.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user. The email address serves as a uniquer identifier for each user and
         *        cannot be changed after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * Indicates the type of user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permissions group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Indicates the type of user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permissions group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permissions group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Indicates the type of user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permissions group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(UserType type);

        /**
         * <p>
         * Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
         * credentials that can then be used to access other FinSpace Data API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the APIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any APIs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
         *        credentials that can then be used to access other FinSpace Data API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the APIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any APIs.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(String apiAccess);

        /**
         * <p>
         * Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
         * credentials that can then be used to access other FinSpace Data API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the APIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any APIs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        Indicates whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
         *        credentials that can then be used to access other FinSpace Data API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the APIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any APIs.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(ApiAccess apiAccess);

        /**
         * <p>
         * The ARN identifier of an AWS user or role that is allowed to call the
         * <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user.
         * This must be an IAM role within your FinSpace account.
         * </p>
         * 
         * @param apiAccessPrincipalArn
         *        The ARN identifier of an AWS user or role that is allowed to call the
         *        <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific
         *        FinSpace user. This must be an IAM role within your FinSpace account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiAccessPrincipalArn(String apiAccessPrincipalArn);

        /**
         * <p>
         * The timestamp at which the user account was created in FinSpace. The value is determined as epoch time in
         * milliseconds.
         * </p>
         * 
         * @param createTime
         *        The timestamp at which the user account was created in FinSpace. The value is determined as epoch time
         *        in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * Describes the last time the user account was enabled. The value is determined as epoch time in milliseconds.
         * </p>
         * 
         * @param lastEnabledTime
         *        Describes the last time the user account was enabled. The value is determined as epoch time in
         *        milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEnabledTime(Long lastEnabledTime);

        /**
         * <p>
         * Describes the last time the user account was disabled. The value is determined as epoch time in milliseconds.
         * </p>
         * 
         * @param lastDisabledTime
         *        Describes the last time the user account was disabled. The value is determined as epoch time in
         *        milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDisabledTime(Long lastDisabledTime);

        /**
         * <p>
         * Describes the last time the user account was updated. The value is determined as epoch time in milliseconds.
         * </p>
         * 
         * @param lastModifiedTime
         *        Describes the last time the user account was updated. The value is determined as epoch time in
         *        milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * Describes the last time that the user logged into their account. The value is determined as epoch time in
         * milliseconds.
         * </p>
         * 
         * @param lastLoginTime
         *        Describes the last time that the user logged into their account. The value is determined as epoch time
         *        in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastLoginTime(Long lastLoginTime);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String status;

        private String firstName;

        private String lastName;

        private String emailAddress;

        private String type;

        private String apiAccess;

        private String apiAccessPrincipalArn;

        private Long createTime;

        private Long lastEnabledTime;

        private Long lastDisabledTime;

        private Long lastModifiedTime;

        private Long lastLoginTime;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            userId(model.userId);
            status(model.status);
            firstName(model.firstName);
            lastName(model.lastName);
            emailAddress(model.emailAddress);
            type(model.type);
            apiAccess(model.apiAccess);
            apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            createTime(model.createTime);
            lastEnabledTime(model.lastEnabledTime);
            lastDisabledTime(model.lastDisabledTime);
            lastModifiedTime(model.lastModifiedTime);
            lastLoginTime(model.lastLoginTime);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApiAccess() {
            return apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastEnabledTime() {
            return lastEnabledTime;
        }

        public final void setLastEnabledTime(Long lastEnabledTime) {
            this.lastEnabledTime = lastEnabledTime;
        }

        @Override
        public final Builder lastEnabledTime(Long lastEnabledTime) {
            this.lastEnabledTime = lastEnabledTime;
            return this;
        }

        public final Long getLastDisabledTime() {
            return lastDisabledTime;
        }

        public final void setLastDisabledTime(Long lastDisabledTime) {
            this.lastDisabledTime = lastDisabledTime;
        }

        @Override
        public final Builder lastDisabledTime(Long lastDisabledTime) {
            this.lastDisabledTime = lastDisabledTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getLastLoginTime() {
            return lastLoginTime;
        }

        public final void setLastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
        }

        @Override
        public final Builder lastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
