/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExternalDataViewAccessDetailsResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetExternalDataViewAccessDetailsResponse.Builder, GetExternalDataViewAccessDetailsResponse> {
    private static final SdkField<AwsCredentials> CREDENTIALS_FIELD = SdkField.<AwsCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("credentials").getter(getter(GetExternalDataViewAccessDetailsResponse::credentials))
            .setter(setter(Builder::credentials)).constructor(AwsCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("s3Location").getter(getter(GetExternalDataViewAccessDetailsResponse::s3Location))
            .setter(setter(Builder::s3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            S3_LOCATION_FIELD));

    private final AwsCredentials credentials;

    private final S3Location s3Location;

    private GetExternalDataViewAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The credentials required to access the external Dataview from the S3 location.
     * </p>
     * 
     * @return The credentials required to access the external Dataview from the S3 location.
     */
    public final AwsCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The location where the external Dataview is stored.
     * </p>
     * 
     * @return The location where the external Dataview is stored.
     */
    public final S3Location s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExternalDataViewAccessDetailsResponse)) {
            return false;
        }
        GetExternalDataViewAccessDetailsResponse other = (GetExternalDataViewAccessDetailsResponse) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExternalDataViewAccessDetailsResponse").add("Credentials", credentials())
                .add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExternalDataViewAccessDetailsResponse, T> g) {
        return obj -> g.apply((GetExternalDataViewAccessDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetExternalDataViewAccessDetailsResponse> {
        /**
         * <p>
         * The credentials required to access the external Dataview from the S3 location.
         * </p>
         * 
         * @param credentials
         *        The credentials required to access the external Dataview from the S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(AwsCredentials credentials);

        /**
         * <p>
         * The credentials required to access the external Dataview from the S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCredentials.Builder} avoiding the need
         * to create one manually via {@link AwsCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #credentials(AwsCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link AwsCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(AwsCredentials)
         */
        default Builder credentials(Consumer<AwsCredentials.Builder> credentials) {
            return credentials(AwsCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The location where the external Dataview is stored.
         * </p>
         * 
         * @param s3Location
         *        The location where the external Dataview is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * The location where the external Dataview is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3Location)
         */
        default Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return s3Location(S3Location.builder().applyMutation(s3Location).build());
        }
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private AwsCredentials credentials;

        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExternalDataViewAccessDetailsResponse model) {
            super(model);
            credentials(model.credentials);
            s3Location(model.s3Location);
        }

        public final AwsCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(AwsCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(AwsCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final S3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public GetExternalDataViewAccessDetailsResponse build() {
            return new GetExternalDataViewAccessDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
