/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response for GetProgrammaticAccessCredentials operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProgrammaticAccessCredentialsResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetProgrammaticAccessCredentialsResponse.Builder, GetProgrammaticAccessCredentialsResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("credentials").getter(getter(GetProgrammaticAccessCredentialsResponse::credentials))
            .setter(setter(Builder::credentials)).constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final SdkField<Long> DURATION_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationInMinutes").getter(getter(GetProgrammaticAccessCredentialsResponse::durationInMinutes))
            .setter(setter(Builder::durationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            DURATION_IN_MINUTES_FIELD));

    private final Credentials credentials;

    private final Long durationInMinutes;

    private GetProgrammaticAccessCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.durationInMinutes = builder.durationInMinutes;
    }

    /**
     * <p>
     * Returns the programmatic credentials.
     * </p>
     * 
     * @return Returns the programmatic credentials.
     */
    public final Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * Returns the duration in which the credentials will remain valid.
     * </p>
     * 
     * @return Returns the duration in which the credentials will remain valid.
     */
    public final Long durationInMinutes() {
        return durationInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(durationInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProgrammaticAccessCredentialsResponse)) {
            return false;
        }
        GetProgrammaticAccessCredentialsResponse other = (GetProgrammaticAccessCredentialsResponse) obj;
        return Objects.equals(credentials(), other.credentials())
                && Objects.equals(durationInMinutes(), other.durationInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProgrammaticAccessCredentialsResponse").add("Credentials", credentials())
                .add("DurationInMinutes", durationInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "durationInMinutes":
            return Optional.ofNullable(clazz.cast(durationInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProgrammaticAccessCredentialsResponse, T> g) {
        return obj -> g.apply((GetProgrammaticAccessCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProgrammaticAccessCredentialsResponse> {
        /**
         * <p>
         * Returns the programmatic credentials.
         * </p>
         * 
         * @param credentials
         *        Returns the programmatic credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * Returns the programmatic credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * Returns the duration in which the credentials will remain valid.
         * </p>
         * 
         * @param durationInMinutes
         *        Returns the duration in which the credentials will remain valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInMinutes(Long durationInMinutes);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private Long durationInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProgrammaticAccessCredentialsResponse model) {
            super(model);
            credentials(model.credentials);
            durationInMinutes(model.durationInMinutes);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Long getDurationInMinutes() {
            return durationInMinutes;
        }

        public final void setDurationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }

        @Override
        public final Builder durationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
            return this;
        }

        @Override
        public GetProgrammaticAccessCredentialsResponse build() {
            return new GetProgrammaticAccessCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
