/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProgrammaticAccessCredentialsRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<GetProgrammaticAccessCredentialsRequest.Builder, GetProgrammaticAccessCredentialsRequest> {
    private static final SdkField<Long> DURATION_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationInMinutes").getter(getter(GetProgrammaticAccessCredentialsRequest::durationInMinutes))
            .setter(setter(Builder::durationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("durationInMinutes").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetProgrammaticAccessCredentialsRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_MINUTES_FIELD,
            ENVIRONMENT_ID_FIELD));

    private final Long durationInMinutes;

    private final String environmentId;

    private GetProgrammaticAccessCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.durationInMinutes = builder.durationInMinutes;
        this.environmentId = builder.environmentId;
    }

    /**
     * <p>
     * The time duration in which the credentials remain valid.
     * </p>
     * 
     * @return The time duration in which the credentials remain valid.
     */
    public final Long durationInMinutes() {
        return durationInMinutes;
    }

    /**
     * <p>
     * The habanero environment identifier.
     * </p>
     * 
     * @return The habanero environment identifier.
     */
    public final String environmentId() {
        return environmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProgrammaticAccessCredentialsRequest)) {
            return false;
        }
        GetProgrammaticAccessCredentialsRequest other = (GetProgrammaticAccessCredentialsRequest) obj;
        return Objects.equals(durationInMinutes(), other.durationInMinutes())
                && Objects.equals(environmentId(), other.environmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProgrammaticAccessCredentialsRequest").add("DurationInMinutes", durationInMinutes())
                .add("EnvironmentId", environmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "durationInMinutes":
            return Optional.ofNullable(clazz.cast(durationInMinutes()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProgrammaticAccessCredentialsRequest, T> g) {
        return obj -> g.apply((GetProgrammaticAccessCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProgrammaticAccessCredentialsRequest> {
        /**
         * <p>
         * The time duration in which the credentials remain valid.
         * </p>
         * 
         * @param durationInMinutes
         *        The time duration in which the credentials remain valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInMinutes(Long durationInMinutes);

        /**
         * <p>
         * The habanero environment identifier.
         * </p>
         * 
         * @param environmentId
         *        The habanero environment identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private Long durationInMinutes;

        private String environmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProgrammaticAccessCredentialsRequest model) {
            super(model);
            durationInMinutes(model.durationInMinutes);
            environmentId(model.environmentId);
        }

        public final Long getDurationInMinutes() {
            return durationInMinutes;
        }

        public final void setDurationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }

        @Override
        @Transient
        public final Builder durationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProgrammaticAccessCredentialsRequest build() {
            return new GetProgrammaticAccessCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
