/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.LocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkingLocationRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, GetWorkingLocationRequest> {
    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locationType").getter(GetWorkingLocationRequest.getter(GetWorkingLocationRequest::locationTypeAsString)).setter(GetWorkingLocationRequest.setter(Builder::locationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_TYPE_FIELD));
    private final String locationType;

    private GetWorkingLocationRequest(BuilderImpl builder) {
        super(builder);
        this.locationType = builder.locationType;
    }

    public final LocationType locationType() {
        return LocationType.fromValue(this.locationType);
    }

    public final String locationTypeAsString() {
        return this.locationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkingLocationRequest)) {
            return false;
        }
        GetWorkingLocationRequest other = (GetWorkingLocationRequest)((Object)obj);
        return Objects.equals(this.locationTypeAsString(), other.locationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkingLocationRequest").add("LocationType", (Object)this.locationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationType": {
                return Optional.ofNullable(clazz.cast(this.locationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkingLocationRequest, T> g) {
        return obj -> g.apply((GetWorkingLocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String locationType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkingLocationRequest model) {
            super(model);
            this.locationType(model.locationType);
        }

        public final String getLocationType() {
            return this.locationType;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        @Override
        @Transient
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        @Transient
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkingLocationRequest build() {
            return new GetWorkingLocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkingLocationRequest> {
        public Builder locationType(String var1);

        public Builder locationType(LocationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

