/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ErrorCategory {
    THE_INPUTS_TO_THIS_REQUEST_ARE_INVALID("The_inputs_to_this_request_are_invalid"),

    SERVICE_LIMITS_HAVE_BEEN_EXCEEDED("Service_limits_have_been_exceeded"),

    MISSING_REQUIRED_PERMISSION_TO_PERFORM_THIS_REQUEST("Missing_required_permission_to_perform_this_request"),

    ONE_OR_MORE_INPUTS_TO_THIS_REQUEST_WERE_NOT_FOUND("One_or_more_inputs_to_this_request_were_not_found"),

    THE_SYSTEM_TEMPORARILY_LACKS_SUFFICIENT_RESOURCES_TO_PROCESS_THE_REQUEST(
            "The_system_temporarily_lacks_sufficient_resources_to_process_the_request"),

    AN_INTERNAL_ERROR_HAS_OCCURRED("An_internal_error_has_occurred"),

    CANCELLED("Cancelled"),

    A_USER_RECOVERABLE_ERROR_HAS_OCCURRED("A_user_recoverable_error_has_occurred"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCategory> VALUE_MAP = EnumUtils.uniqueIndex(ErrorCategory.class,
            ErrorCategory::toString);

    private final String value;

    private ErrorCategory(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ErrorCategory corresponding to the value
     */
    public static ErrorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ErrorCategory}s
     */
    public static Set<ErrorCategory> knownValues() {
        Set<ErrorCategory> knownValues = EnumSet.allOf(ErrorCategory.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
