/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A changeset is unit of data in a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangesetInfo implements SdkPojo, Serializable, ToCopyableBuilder<ChangesetInfo.Builder, ChangesetInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ChangesetInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> CHANGESET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetArn").getter(getter(ChangesetInfo::changesetArn)).setter(setter(Builder::changesetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetArn").build()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(ChangesetInfo::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(ChangesetInfo::changeTypeAsString)).setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(ChangesetInfo::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sourceParams")
            .getter(getter(ChangesetInfo::sourceParams))
            .setter(setter(Builder::sourceParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formatType").getter(getter(ChangesetInfo::formatTypeAsString)).setter(setter(Builder::formatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatType").build()).build();

    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("formatParams")
            .getter(getter(ChangesetInfo::formatParams))
            .setter(setter(Builder::formatParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTimestamp").getter(getter(ChangesetInfo::createTimestamp))
            .setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ChangesetInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("errorInfo").getter(getter(ChangesetInfo::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Map<String, String>> CHANGESET_LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("changesetLabels")
            .getter(getter(ChangesetInfo::changesetLabels))
            .setter(setter(Builder::changesetLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetLabels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UPDATES_CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatesChangesetId").getter(getter(ChangesetInfo::updatesChangesetId))
            .setter(setter(Builder::updatesChangesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatesChangesetId").build())
            .build();

    private static final SdkField<String> UPDATED_BY_CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedByChangesetId").getter(getter(ChangesetInfo::updatedByChangesetId))
            .setter(setter(Builder::updatedByChangesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedByChangesetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CHANGESET_ARN_FIELD,
            DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_TYPE_FIELD, FORMAT_PARAMS_FIELD,
            CREATE_TIMESTAMP_FIELD, STATUS_FIELD, ERROR_INFO_FIELD, CHANGESET_LABELS_FIELD, UPDATES_CHANGESET_ID_FIELD,
            UPDATED_BY_CHANGESET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String changesetArn;

    private final String datasetId;

    private final String changeType;

    private final String sourceType;

    private final Map<String, String> sourceParams;

    private final String formatType;

    private final Map<String, String> formatParams;

    private final Instant createTimestamp;

    private final String status;

    private final ErrorInfo errorInfo;

    private final Map<String, String> changesetLabels;

    private final String updatesChangesetId;

    private final String updatedByChangesetId;

    private ChangesetInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.changesetArn = builder.changesetArn;
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceType = builder.sourceType;
        this.sourceParams = builder.sourceParams;
        this.formatType = builder.formatType;
        this.formatParams = builder.formatParams;
        this.createTimestamp = builder.createTimestamp;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
        this.changesetLabels = builder.changesetLabels;
        this.updatesChangesetId = builder.updatesChangesetId;
        this.updatedByChangesetId = builder.updatedByChangesetId;
    }

    /**
     * <p>
     * Unique identifier for a changeset.
     * </p>
     * 
     * @return Unique identifier for a changeset.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN identifier of the changeset.
     * </p>
     * 
     * @return The ARN identifier of the changeset.
     */
    public final String changesetArn() {
        return changesetArn;
    }

    /**
     * <p>
     * The unique identifier for the FinSpace dataset in which the changeset is created.
     * </p>
     * 
     * @return The unique identifier for the FinSpace dataset in which the changeset is created.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * Change type indicates how a changeset is applied to a dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Change type indicates how a changeset is applied to a dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Change type indicates how a changeset is applied to a dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Change type indicates how a changeset is applied to a dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    /**
     * <p>
     * Type of the data source from which the files to create the changeset are sourced.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code> - Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Type of the data source from which the files to create the changeset are sourced.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code> - Amazon S3.
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Type of the data source from which the files to create the changeset are sourced.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code> - Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Type of the data source from which the files to create the changeset are sourced.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code> - Amazon S3.
     *         </p>
     *         </li>
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceParams() {
        return sourceParams != null && !(sourceParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Source path from which the files to create the changeset are sourced.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceParams} method.
     * </p>
     * 
     * @return Source path from which the files to create the changeset are sourced.
     */
    public final Map<String, String> sourceParams() {
        return sourceParams;
    }

    /**
     * <p>
     * Format type of the input files loaded into the changeset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link FormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatTypeAsString}.
     * </p>
     * 
     * @return Format type of the input files loaded into the changeset.
     * @see FormatType
     */
    public final FormatType formatType() {
        return FormatType.fromValue(formatType);
    }

    /**
     * <p>
     * Format type of the input files loaded into the changeset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link FormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatTypeAsString}.
     * </p>
     * 
     * @return Format type of the input files loaded into the changeset.
     * @see FormatType
     */
    public final String formatTypeAsString() {
        return formatType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormatParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormatParams() {
        return formatParams != null && !(formatParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Structure of the source file(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatParams} method.
     * </p>
     * 
     * @return Structure of the source file(s).
     */
    public final Map<String, String> formatParams() {
        return formatParams;
    }

    /**
     * <p>
     * The timestamp at which the changeset was created in FinSpace.
     * </p>
     * 
     * @return The timestamp at which the changeset was created in FinSpace.
     */
    public final Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The status of changeset creation operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of changeset creation operation.
     * @see ChangesetStatus
     */
    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of changeset creation operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangesetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of changeset creation operation.
     * @see ChangesetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The structure with error messages.
     * </p>
     * 
     * @return The structure with error messages.
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangesetLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangesetLabels() {
        return changesetLabels != null && !(changesetLabels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the changeset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangesetLabels} method.
     * </p>
     * 
     * @return Tags associated with the changeset.
     */
    public final Map<String, String> changesetLabels() {
        return changesetLabels;
    }

    /**
     * <p>
     * Unique identifier of the changeset that is updated.
     * </p>
     * 
     * @return Unique identifier of the changeset that is updated.
     */
    public final String updatesChangesetId() {
        return updatesChangesetId;
    }

    /**
     * <p>
     * Unique identifier of the changeset that is updated a changeset.
     * </p>
     * 
     * @return Unique identifier of the changeset that is updated a changeset.
     */
    public final String updatedByChangesetId() {
        return updatedByChangesetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(changesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceParams() ? sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatParams() ? formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangesetLabels() ? changesetLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatesChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedByChangesetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangesetInfo)) {
            return false;
        }
        ChangesetInfo other = (ChangesetInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(changesetArn(), other.changesetArn())
                && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && hasSourceParams() == other.hasSourceParams() && Objects.equals(sourceParams(), other.sourceParams())
                && Objects.equals(formatTypeAsString(), other.formatTypeAsString())
                && hasFormatParams() == other.hasFormatParams() && Objects.equals(formatParams(), other.formatParams())
                && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorInfo(), other.errorInfo())
                && hasChangesetLabels() == other.hasChangesetLabels()
                && Objects.equals(changesetLabels(), other.changesetLabels())
                && Objects.equals(updatesChangesetId(), other.updatesChangesetId())
                && Objects.equals(updatedByChangesetId(), other.updatedByChangesetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangesetInfo").add("Id", id()).add("ChangesetArn", changesetArn())
                .add("DatasetId", datasetId()).add("ChangeType", changeTypeAsString()).add("SourceType", sourceTypeAsString())
                .add("SourceParams", hasSourceParams() ? sourceParams() : null).add("FormatType", formatTypeAsString())
                .add("FormatParams", hasFormatParams() ? formatParams() : null).add("CreateTimestamp", createTimestamp())
                .add("Status", statusAsString()).add("ErrorInfo", errorInfo())
                .add("ChangesetLabels", hasChangesetLabels() ? changesetLabels() : null)
                .add("UpdatesChangesetId", updatesChangesetId()).add("UpdatedByChangesetId", updatedByChangesetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "changesetArn":
            return Optional.ofNullable(clazz.cast(changesetArn()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "sourceParams":
            return Optional.ofNullable(clazz.cast(sourceParams()));
        case "formatType":
            return Optional.ofNullable(clazz.cast(formatTypeAsString()));
        case "formatParams":
            return Optional.ofNullable(clazz.cast(formatParams()));
        case "createTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "changesetLabels":
            return Optional.ofNullable(clazz.cast(changesetLabels()));
        case "updatesChangesetId":
            return Optional.ofNullable(clazz.cast(updatesChangesetId()));
        case "updatedByChangesetId":
            return Optional.ofNullable(clazz.cast(updatedByChangesetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangesetInfo, T> g) {
        return obj -> g.apply((ChangesetInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangesetInfo> {
        /**
         * <p>
         * Unique identifier for a changeset.
         * </p>
         * 
         * @param id
         *        Unique identifier for a changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN identifier of the changeset.
         * </p>
         * 
         * @param changesetArn
         *        The ARN identifier of the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetArn(String changesetArn);

        /**
         * <p>
         * The unique identifier for the FinSpace dataset in which the changeset is created.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the FinSpace dataset in which the changeset is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * Change type indicates how a changeset is applied to a dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Change type indicates how a changeset is applied to a dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded
         *        changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Change type indicates how a changeset is applied to a dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Change type indicates how a changeset is applied to a dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded
         *        changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested changeset.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);

        /**
         * <p>
         * Type of the data source from which the files to create the changeset are sourced.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code> - Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        Type of the data source from which the files to create the changeset are sourced.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code> - Amazon S3.
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Type of the data source from which the files to create the changeset are sourced.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code> - Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceType
         *        Type of the data source from which the files to create the changeset are sourced.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code> - Amazon S3.
         *        </p>
         *        </li>
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * <p>
         * Source path from which the files to create the changeset are sourced.
         * </p>
         * 
         * @param sourceParams
         *        Source path from which the files to create the changeset are sourced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParams(Map<String, String> sourceParams);

        /**
         * <p>
         * Format type of the input files loaded into the changeset.
         * </p>
         * 
         * @param formatType
         *        Format type of the input files loaded into the changeset.
         * @see FormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatType
         */
        Builder formatType(String formatType);

        /**
         * <p>
         * Format type of the input files loaded into the changeset.
         * </p>
         * 
         * @param formatType
         *        Format type of the input files loaded into the changeset.
         * @see FormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormatType
         */
        Builder formatType(FormatType formatType);

        /**
         * <p>
         * Structure of the source file(s).
         * </p>
         * 
         * @param formatParams
         *        Structure of the source file(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatParams(Map<String, String> formatParams);

        /**
         * <p>
         * The timestamp at which the changeset was created in FinSpace.
         * </p>
         * 
         * @param createTimestamp
         *        The timestamp at which the changeset was created in FinSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * The status of changeset creation operation.
         * </p>
         * 
         * @param status
         *        The status of changeset creation operation.
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of changeset creation operation.
         * </p>
         * 
         * @param status
         *        The status of changeset creation operation.
         * @see ChangesetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangesetStatus
         */
        Builder status(ChangesetStatus status);

        /**
         * <p>
         * The structure with error messages.
         * </p>
         * 
         * @param errorInfo
         *        The structure with error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * <p>
         * The structure with error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to create
         * one manually via {@link ErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * Tags associated with the changeset.
         * </p>
         * 
         * @param changesetLabels
         *        Tags associated with the changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetLabels(Map<String, String> changesetLabels);

        /**
         * <p>
         * Unique identifier of the changeset that is updated.
         * </p>
         * 
         * @param updatesChangesetId
         *        Unique identifier of the changeset that is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatesChangesetId(String updatesChangesetId);

        /**
         * <p>
         * Unique identifier of the changeset that is updated a changeset.
         * </p>
         * 
         * @param updatedByChangesetId
         *        Unique identifier of the changeset that is updated a changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedByChangesetId(String updatedByChangesetId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String changesetArn;

        private String datasetId;

        private String changeType;

        private String sourceType;

        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();

        private String formatType;

        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();

        private Instant createTimestamp;

        private String status;

        private ErrorInfo errorInfo;

        private Map<String, String> changesetLabels = DefaultSdkAutoConstructMap.getInstance();

        private String updatesChangesetId;

        private String updatedByChangesetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangesetInfo model) {
            id(model.id);
            changesetArn(model.changesetArn);
            datasetId(model.datasetId);
            changeType(model.changeType);
            sourceType(model.sourceType);
            sourceParams(model.sourceParams);
            formatType(model.formatType);
            formatParams(model.formatParams);
            createTimestamp(model.createTimestamp);
            status(model.status);
            errorInfo(model.errorInfo);
            changesetLabels(model.changesetLabels);
            updatesChangesetId(model.updatesChangesetId);
            updatedByChangesetId(model.updatedByChangesetId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getChangesetArn() {
            return changesetArn;
        }

        public final void setChangesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
        }

        @Override
        @Transient
        public final Builder changesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        @Transient
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        @Transient
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        @Transient
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
        }

        @Override
        @Transient
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
            return this;
        }

        public final String getFormatType() {
            return formatType;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        @Override
        @Transient
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        @Transient
        public final Builder formatType(FormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
        }

        @Override
        @Transient
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
            return this;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        @Transient
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Map<String, String> getChangesetLabels() {
            if (changesetLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return changesetLabels;
        }

        public final void setChangesetLabels(Map<String, String> changesetLabels) {
            this.changesetLabels = _stringMapCopier.copy(changesetLabels);
        }

        @Override
        @Transient
        public final Builder changesetLabels(Map<String, String> changesetLabels) {
            this.changesetLabels = _stringMapCopier.copy(changesetLabels);
            return this;
        }

        public final String getUpdatesChangesetId() {
            return updatesChangesetId;
        }

        public final void setUpdatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
        }

        @Override
        @Transient
        public final Builder updatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
            return this;
        }

        public final String getUpdatedByChangesetId() {
            return updatedByChangesetId;
        }

        public final void setUpdatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
        }

        @Override
        @Transient
        public final Builder updatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
            return this;
        }

        @Override
        public ChangesetInfo build() {
            return new ChangesetInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
