/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspacedata.model.ChangeType;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.FormatType;
import software.amazon.awssdk.services.finspacedata.model.SourceType;
import software.amazon.awssdk.services.finspacedata.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChangesetRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreateChangesetRequest> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(CreateChangesetRequest.getter(CreateChangesetRequest::datasetId)).setter(CreateChangesetRequest.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(CreateChangesetRequest.getter(CreateChangesetRequest::changeTypeAsString)).setter(CreateChangesetRequest.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(CreateChangesetRequest.getter(CreateChangesetRequest::sourceTypeAsString)).setter(CreateChangesetRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sourceParams").getter(CreateChangesetRequest.getter(CreateChangesetRequest::sourceParams)).setter(CreateChangesetRequest.setter(Builder::sourceParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formatType").getter(CreateChangesetRequest.getter(CreateChangesetRequest::formatTypeAsString)).setter(CreateChangesetRequest.setter(Builder::formatType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatType").build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formatParams").getter(CreateChangesetRequest.getter(CreateChangesetRequest::formatParams)).setter(CreateChangesetRequest.setter(Builder::formatParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateChangesetRequest.getter(CreateChangesetRequest::tags)).setter(CreateChangesetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_TYPE_FIELD, FORMAT_PARAMS_FIELD, TAGS_FIELD));
    private final String datasetId;
    private final String changeType;
    private final String sourceType;
    private final Map<String, String> sourceParams;
    private final String formatType;
    private final Map<String, String> formatParams;
    private final Map<String, String> tags;

    private CreateChangesetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceType = builder.sourceType;
        this.sourceParams = builder.sourceParams;
        this.formatType = builder.formatType;
        this.formatParams = builder.formatParams;
        this.tags = builder.tags;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final boolean hasSourceParams() {
        return this.sourceParams != null && !(this.sourceParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceParams() {
        return this.sourceParams;
    }

    public final FormatType formatType() {
        return FormatType.fromValue(this.formatType);
    }

    public final String formatTypeAsString() {
        return this.formatType;
    }

    public final boolean hasFormatParams() {
        return this.formatParams != null && !(this.formatParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatParams() {
        return this.formatParams;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceParams() ? this.sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.formatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatParams() ? this.formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangesetRequest)) {
            return false;
        }
        CreateChangesetRequest other = (CreateChangesetRequest)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && this.hasSourceParams() == other.hasSourceParams() && Objects.equals(this.sourceParams(), other.sourceParams()) && Objects.equals(this.formatTypeAsString(), other.formatTypeAsString()) && this.hasFormatParams() == other.hasFormatParams() && Objects.equals(this.formatParams(), other.formatParams()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChangesetRequest").add("DatasetId", (Object)this.datasetId()).add("ChangeType", (Object)this.changeTypeAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("SourceParams", this.hasSourceParams() ? this.sourceParams() : null).add("FormatType", (Object)this.formatTypeAsString()).add("FormatParams", this.hasFormatParams() ? this.formatParams() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceParams": {
                return Optional.ofNullable(clazz.cast(this.sourceParams()));
            }
            case "formatType": {
                return Optional.ofNullable(clazz.cast(this.formatTypeAsString()));
            }
            case "formatParams": {
                return Optional.ofNullable(clazz.cast(this.formatParams()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChangesetRequest, T> g) {
        return obj -> g.apply((CreateChangesetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String datasetId;
        private String changeType;
        private String sourceType;
        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();
        private String formatType;
        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangesetRequest model) {
            super(model);
            this.datasetId(model.datasetId);
            this.changeType(model.changeType);
            this.sourceType(model.sourceType);
            this.sourceParams(model.sourceParams);
            this.formatType(model.formatType);
            this.formatParams(model.formatParams);
            this.tags(model.tags);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        @Transient
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        @Transient
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        @Transient
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (this.sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
        }

        @Override
        @Transient
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
            return this;
        }

        public final String getFormatType() {
            return this.formatType;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        @Override
        @Transient
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        @Transient
        public final Builder formatType(FormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (this.formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
        }

        @Override
        @Transient
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChangesetRequest build() {
            return new CreateChangesetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChangesetRequest> {
        public Builder datasetId(String var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceParams(Map<String, String> var1);

        public Builder formatType(String var1);

        public Builder formatType(FormatType var1);

        public Builder formatParams(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

