/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Definition for a schema on a tabular Dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaDefinition.Builder, SchemaDefinition> {
    private static final SdkField<List<ColumnDefinition>> COLUMNS_FIELD = SdkField
            .<List<ColumnDefinition>> builder(MarshallingType.LIST)
            .memberName("columns")
            .getter(getter(SchemaDefinition::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRIMARY_KEY_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("primaryKeyColumns")
            .getter(getter(SchemaDefinition::primaryKeyColumns))
            .setter(setter(Builder::primaryKeyColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKeyColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD,
            PRIMARY_KEY_COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ColumnDefinition> columns;

    private final List<String> primaryKeyColumns;

    private SchemaDefinition(BuilderImpl builder) {
        this.columns = builder.columns;
        this.primaryKeyColumns = builder.primaryKeyColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of column definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return List of column definitions.
     */
    public final List<ColumnDefinition> columns() {
        return columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryKeyColumns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryKeyColumns() {
        return primaryKeyColumns != null && !(primaryKeyColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of column names used for primary key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryKeyColumns} method.
     * </p>
     * 
     * @return List of column names used for primary key.
     */
    public final List<String> primaryKeyColumns() {
        return primaryKeyColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryKeyColumns() ? primaryKeyColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition) obj;
        return hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns())
                && hasPrimaryKeyColumns() == other.hasPrimaryKeyColumns()
                && Objects.equals(primaryKeyColumns(), other.primaryKeyColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaDefinition").add("Columns", hasColumns() ? columns() : null)
                .add("PrimaryKeyColumns", hasPrimaryKeyColumns() ? primaryKeyColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "primaryKeyColumns":
            return Optional.ofNullable(clazz.cast(primaryKeyColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaDefinition> {
        /**
         * <p>
         * List of column definitions.
         * </p>
         * 
         * @param columns
         *        List of column definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<ColumnDefinition> columns);

        /**
         * <p>
         * List of column definitions.
         * </p>
         * 
         * @param columns
         *        List of column definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(ColumnDefinition... columns);

        /**
         * <p>
         * List of column definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<ColumnDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #columns(List<ColumnDefinition>)}.
         * 
         * @param columns
         *        a consumer that will call methods on {@link List<ColumnDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(List<ColumnDefinition>)
         */
        Builder columns(Consumer<ColumnDefinition.Builder>... columns);

        /**
         * <p>
         * List of column names used for primary key.
         * </p>
         * 
         * @param primaryKeyColumns
         *        List of column names used for primary key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeyColumns(Collection<String> primaryKeyColumns);

        /**
         * <p>
         * List of column names used for primary key.
         * </p>
         * 
         * @param primaryKeyColumns
         *        List of column names used for primary key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeyColumns(String... primaryKeyColumns);
    }

    static final class BuilderImpl implements Builder {
        private List<ColumnDefinition> columns = DefaultSdkAutoConstructList.getInstance();

        private List<String> primaryKeyColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            columns(model.columns);
            primaryKeyColumns(model.primaryKeyColumns);
        }

        public final List<ColumnDefinition.Builder> getColumns() {
            List<ColumnDefinition.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<ColumnDefinition.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        @Transient
        public final Builder columns(Collection<ColumnDefinition> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(ColumnDefinition... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Consumer<ColumnDefinition.Builder>... columns) {
            columns(Stream.of(columns).map(c -> ColumnDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrimaryKeyColumns() {
            if (primaryKeyColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return primaryKeyColumns;
        }

        public final void setPrimaryKeyColumns(Collection<String> primaryKeyColumns) {
            this.primaryKeyColumns = ColumnNameListCopier.copy(primaryKeyColumns);
        }

        @Override
        @Transient
        public final Builder primaryKeyColumns(Collection<String> primaryKeyColumns) {
            this.primaryKeyColumns = ColumnNameListCopier.copy(primaryKeyColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder primaryKeyColumns(String... primaryKeyColumns) {
            primaryKeyColumns(Arrays.asList(primaryKeyColumns));
            return this;
        }

        @Override
        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
