/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request to update an existing changeset.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChangesetRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<UpdateChangesetRequest.Builder, UpdateChangesetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateChangesetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(UpdateChangesetRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(UpdateChangesetRequest::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("changesetId").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sourceParams")
            .getter(getter(UpdateChangesetRequest::sourceParams))
            .setter(setter(Builder::sourceParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("formatParams")
            .getter(getter(UpdateChangesetRequest::formatParams))
            .setter(setter(Builder::formatParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATASET_ID_FIELD, CHANGESET_ID_FIELD, SOURCE_PARAMS_FIELD, FORMAT_PARAMS_FIELD));

    private final String clientToken;

    private final String datasetId;

    private final String changesetId;

    private final Map<String, String> sourceParams;

    private final Map<String, String> formatParams;

    private UpdateChangesetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetId = builder.datasetId;
        this.changesetId = builder.changesetId;
        this.sourceParams = builder.sourceParams;
        this.formatParams = builder.formatParams;
    }

    /**
     * <p>
     * A token used to ensure idempotency.
     * </p>
     * 
     * @return A token used to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier for the FinSpace Dataset in which the Changeset is created.
     * </p>
     * 
     * @return The unique identifier for the FinSpace Dataset in which the Changeset is created.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The unique identifier for the Changeset to update.
     * </p>
     * 
     * @return The unique identifier for the Changeset to update.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceParams() {
        return sourceParams != null && !(sourceParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Options that define the location of the data being ingested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceParams} method.
     * </p>
     * 
     * @return Options that define the location of the data being ingested.
     */
    public final Map<String, String> sourceParams() {
        return sourceParams;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormatParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormatParams() {
        return formatParams != null && !(formatParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Options that define the structure of the source file(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatParams} method.
     * </p>
     * 
     * @return Options that define the structure of the source file(s).
     */
    public final Map<String, String> formatParams() {
        return formatParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceParams() ? sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatParams() ? formatParams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChangesetRequest)) {
            return false;
        }
        UpdateChangesetRequest other = (UpdateChangesetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(changesetId(), other.changesetId()) && hasSourceParams() == other.hasSourceParams()
                && Objects.equals(sourceParams(), other.sourceParams()) && hasFormatParams() == other.hasFormatParams()
                && Objects.equals(formatParams(), other.formatParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChangesetRequest").add("ClientToken", clientToken()).add("DatasetId", datasetId())
                .add("ChangesetId", changesetId()).add("SourceParams", hasSourceParams() ? sourceParams() : null)
                .add("FormatParams", hasFormatParams() ? formatParams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "sourceParams":
            return Optional.ofNullable(clazz.cast(sourceParams()));
        case "formatParams":
            return Optional.ofNullable(clazz.cast(formatParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChangesetRequest, T> g) {
        return obj -> g.apply((UpdateChangesetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChangesetRequest> {
        /**
         * <p>
         * A token used to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        A token used to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier for the FinSpace Dataset in which the Changeset is created.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the FinSpace Dataset in which the Changeset is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The unique identifier for the Changeset to update.
         * </p>
         * 
         * @param changesetId
         *        The unique identifier for the Changeset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * Options that define the location of the data being ingested.
         * </p>
         * 
         * @param sourceParams
         *        Options that define the location of the data being ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParams(Map<String, String> sourceParams);

        /**
         * <p>
         * Options that define the structure of the source file(s).
         * </p>
         * 
         * @param formatParams
         *        Options that define the structure of the source file(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatParams(Map<String, String> formatParams);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String datasetId;

        private String changesetId;

        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChangesetRequest model) {
            super(model);
            clientToken(model.clientToken);
            datasetId(model.datasetId);
            changesetId(model.changesetId);
            sourceParams(model.sourceParams);
            formatParams(model.formatParams);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        @Transient
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        @Transient
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
        }

        @Override
        @Transient
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
        }

        @Override
        @Transient
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChangesetRequest build() {
            return new UpdateChangesetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
