/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of a column in a tabular Dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnDefinition.Builder, ColumnDefinition> {
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(ColumnDefinition::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(ColumnDefinition::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<String> COLUMN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnDescription").getter(getter(ColumnDefinition::columnDescription))
            .setter(setter(Builder::columnDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD,
            COLUMN_NAME_FIELD, COLUMN_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataType;

    private final String columnName;

    private final String columnDescription;

    private ColumnDefinition(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.columnName = builder.columnName;
        this.columnDescription = builder.columnDescription;
    }

    /**
     * <p>
     * Data type of a column.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STRING</code> - A String data type.
     * </p>
     * <p>
     * <code>CHAR</code> - A char data type.
     * </p>
     * <p>
     * <code>INTEGER</code> - An integer data type.
     * </p>
     * <p>
     * <code>TINYINT</code> - A tinyint data type.
     * </p>
     * <p>
     * <code>SMALLINT</code> - A smallint data type.
     * </p>
     * <p>
     * <code>BIGINT</code> - A bigint data type.
     * </p>
     * <p>
     * <code>FLOAT</code> - A float data type.
     * </p>
     * <p>
     * <code>DOUBLE</code> - A double data type.
     * </p>
     * <p>
     * <code>DATE</code> - A date data type.
     * </p>
     * <p>
     * <code>DATETIME</code> - A datetime data type.
     * </p>
     * <p>
     * <code>BOOLEAN</code> - A boolean data type.
     * </p>
     * <p>
     * <code>BINARY</code> - A binary data type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link ColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return Data type of a column.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STRING</code> - A String data type.
     *         </p>
     *         <p>
     *         <code>CHAR</code> - A char data type.
     *         </p>
     *         <p>
     *         <code>INTEGER</code> - An integer data type.
     *         </p>
     *         <p>
     *         <code>TINYINT</code> - A tinyint data type.
     *         </p>
     *         <p>
     *         <code>SMALLINT</code> - A smallint data type.
     *         </p>
     *         <p>
     *         <code>BIGINT</code> - A bigint data type.
     *         </p>
     *         <p>
     *         <code>FLOAT</code> - A float data type.
     *         </p>
     *         <p>
     *         <code>DOUBLE</code> - A double data type.
     *         </p>
     *         <p>
     *         <code>DATE</code> - A date data type.
     *         </p>
     *         <p>
     *         <code>DATETIME</code> - A datetime data type.
     *         </p>
     *         <p>
     *         <code>BOOLEAN</code> - A boolean data type.
     *         </p>
     *         <p>
     *         <code>BINARY</code> - A binary data type.
     *         </p>
     *         </li>
     * @see ColumnDataType
     */
    public final ColumnDataType dataType() {
        return ColumnDataType.fromValue(dataType);
    }

    /**
     * <p>
     * Data type of a column.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STRING</code> - A String data type.
     * </p>
     * <p>
     * <code>CHAR</code> - A char data type.
     * </p>
     * <p>
     * <code>INTEGER</code> - An integer data type.
     * </p>
     * <p>
     * <code>TINYINT</code> - A tinyint data type.
     * </p>
     * <p>
     * <code>SMALLINT</code> - A smallint data type.
     * </p>
     * <p>
     * <code>BIGINT</code> - A bigint data type.
     * </p>
     * <p>
     * <code>FLOAT</code> - A float data type.
     * </p>
     * <p>
     * <code>DOUBLE</code> - A double data type.
     * </p>
     * <p>
     * <code>DATE</code> - A date data type.
     * </p>
     * <p>
     * <code>DATETIME</code> - A datetime data type.
     * </p>
     * <p>
     * <code>BOOLEAN</code> - A boolean data type.
     * </p>
     * <p>
     * <code>BINARY</code> - A binary data type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link ColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return Data type of a column.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STRING</code> - A String data type.
     *         </p>
     *         <p>
     *         <code>CHAR</code> - A char data type.
     *         </p>
     *         <p>
     *         <code>INTEGER</code> - An integer data type.
     *         </p>
     *         <p>
     *         <code>TINYINT</code> - A tinyint data type.
     *         </p>
     *         <p>
     *         <code>SMALLINT</code> - A smallint data type.
     *         </p>
     *         <p>
     *         <code>BIGINT</code> - A bigint data type.
     *         </p>
     *         <p>
     *         <code>FLOAT</code> - A float data type.
     *         </p>
     *         <p>
     *         <code>DOUBLE</code> - A double data type.
     *         </p>
     *         <p>
     *         <code>DATE</code> - A date data type.
     *         </p>
     *         <p>
     *         <code>DATETIME</code> - A datetime data type.
     *         </p>
     *         <p>
     *         <code>BOOLEAN</code> - A boolean data type.
     *         </p>
     *         <p>
     *         <code>BINARY</code> - A binary data type.
     *         </p>
     *         </li>
     * @see ColumnDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * Name for a column.
     * </p>
     * 
     * @return Name for a column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * Description for a column.
     * </p>
     * 
     * @return Description for a column.
     */
    public final String columnDescription() {
        return columnDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition) obj;
        return Objects.equals(dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(columnName(), other.columnName())
                && Objects.equals(columnDescription(), other.columnDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnDefinition").add("DataType", dataTypeAsString()).add("ColumnName", columnName())
                .add("ColumnDescription", columnDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "columnDescription":
            return Optional.ofNullable(clazz.cast(columnDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnDefinition, T> g) {
        return obj -> g.apply((ColumnDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnDefinition> {
        /**
         * <p>
         * Data type of a column.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STRING</code> - A String data type.
         * </p>
         * <p>
         * <code>CHAR</code> - A char data type.
         * </p>
         * <p>
         * <code>INTEGER</code> - An integer data type.
         * </p>
         * <p>
         * <code>TINYINT</code> - A tinyint data type.
         * </p>
         * <p>
         * <code>SMALLINT</code> - A smallint data type.
         * </p>
         * <p>
         * <code>BIGINT</code> - A bigint data type.
         * </p>
         * <p>
         * <code>FLOAT</code> - A float data type.
         * </p>
         * <p>
         * <code>DOUBLE</code> - A double data type.
         * </p>
         * <p>
         * <code>DATE</code> - A date data type.
         * </p>
         * <p>
         * <code>DATETIME</code> - A datetime data type.
         * </p>
         * <p>
         * <code>BOOLEAN</code> - A boolean data type.
         * </p>
         * <p>
         * <code>BINARY</code> - A binary data type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataType
         *        Data type of a column.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STRING</code> - A String data type.
         *        </p>
         *        <p>
         *        <code>CHAR</code> - A char data type.
         *        </p>
         *        <p>
         *        <code>INTEGER</code> - An integer data type.
         *        </p>
         *        <p>
         *        <code>TINYINT</code> - A tinyint data type.
         *        </p>
         *        <p>
         *        <code>SMALLINT</code> - A smallint data type.
         *        </p>
         *        <p>
         *        <code>BIGINT</code> - A bigint data type.
         *        </p>
         *        <p>
         *        <code>FLOAT</code> - A float data type.
         *        </p>
         *        <p>
         *        <code>DOUBLE</code> - A double data type.
         *        </p>
         *        <p>
         *        <code>DATE</code> - A date data type.
         *        </p>
         *        <p>
         *        <code>DATETIME</code> - A datetime data type.
         *        </p>
         *        <p>
         *        <code>BOOLEAN</code> - A boolean data type.
         *        </p>
         *        <p>
         *        <code>BINARY</code> - A binary data type.
         *        </p>
         *        </li>
         * @see ColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * Data type of a column.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STRING</code> - A String data type.
         * </p>
         * <p>
         * <code>CHAR</code> - A char data type.
         * </p>
         * <p>
         * <code>INTEGER</code> - An integer data type.
         * </p>
         * <p>
         * <code>TINYINT</code> - A tinyint data type.
         * </p>
         * <p>
         * <code>SMALLINT</code> - A smallint data type.
         * </p>
         * <p>
         * <code>BIGINT</code> - A bigint data type.
         * </p>
         * <p>
         * <code>FLOAT</code> - A float data type.
         * </p>
         * <p>
         * <code>DOUBLE</code> - A double data type.
         * </p>
         * <p>
         * <code>DATE</code> - A date data type.
         * </p>
         * <p>
         * <code>DATETIME</code> - A datetime data type.
         * </p>
         * <p>
         * <code>BOOLEAN</code> - A boolean data type.
         * </p>
         * <p>
         * <code>BINARY</code> - A binary data type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataType
         *        Data type of a column.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STRING</code> - A String data type.
         *        </p>
         *        <p>
         *        <code>CHAR</code> - A char data type.
         *        </p>
         *        <p>
         *        <code>INTEGER</code> - An integer data type.
         *        </p>
         *        <p>
         *        <code>TINYINT</code> - A tinyint data type.
         *        </p>
         *        <p>
         *        <code>SMALLINT</code> - A smallint data type.
         *        </p>
         *        <p>
         *        <code>BIGINT</code> - A bigint data type.
         *        </p>
         *        <p>
         *        <code>FLOAT</code> - A float data type.
         *        </p>
         *        <p>
         *        <code>DOUBLE</code> - A double data type.
         *        </p>
         *        <p>
         *        <code>DATE</code> - A date data type.
         *        </p>
         *        <p>
         *        <code>DATETIME</code> - A datetime data type.
         *        </p>
         *        <p>
         *        <code>BOOLEAN</code> - A boolean data type.
         *        </p>
         *        <p>
         *        <code>BINARY</code> - A binary data type.
         *        </p>
         *        </li>
         * @see ColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataType
         */
        Builder dataType(ColumnDataType dataType);

        /**
         * <p>
         * Name for a column.
         * </p>
         * 
         * @param columnName
         *        Name for a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * Description for a column.
         * </p>
         * 
         * @param columnDescription
         *        Description for a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnDescription(String columnDescription);
    }

    static final class BuilderImpl implements Builder {
        private String dataType;

        private String columnName;

        private String columnDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnDefinition model) {
            dataType(model.dataType);
            columnName(model.columnName);
            columnDescription(model.columnDescription);
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        @Transient
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataType(ColumnDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        @Transient
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnDescription() {
            return columnDescription;
        }

        public final void setColumnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
        }

        @Override
        @Transient
        public final Builder columnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
            return this;
        }

        @Override
        public ColumnDefinition build() {
            return new ColumnDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
