/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure for a Dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dataset implements SdkPojo, Serializable, ToCopyableBuilder<Dataset.Builder, Dataset> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(Dataset::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(Dataset::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetTitle").getter(getter(Dataset::datasetTitle)).setter(setter(Builder::datasetTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()).build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(Dataset::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(Dataset::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<DatasetOwnerInfo> OWNER_INFO_FIELD = SdkField
            .<DatasetOwnerInfo> builder(MarshallingType.SDK_POJO).memberName("ownerInfo").getter(getter(Dataset::ownerInfo))
            .setter(setter(Builder::ownerInfo)).constructor(DatasetOwnerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerInfo").build()).build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createTime").getter(getter(Dataset::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(Dataset::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.<SchemaUnion> builder(MarshallingType.SDK_POJO)
            .memberName("schemaDefinition").getter(getter(Dataset::schemaDefinition)).setter(setter(Builder::schemaDefinition))
            .constructor(SchemaUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(Dataset::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_ARN_FIELD, DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, OWNER_INFO_FIELD, CREATE_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, SCHEMA_DEFINITION_FIELD, ALIAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetId;

    private final String datasetArn;

    private final String datasetTitle;

    private final String kind;

    private final String datasetDescription;

    private final DatasetOwnerInfo ownerInfo;

    private final Long createTime;

    private final Long lastModifiedTime;

    private final SchemaUnion schemaDefinition;

    private final String alias;

    private Dataset(BuilderImpl builder) {
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.ownerInfo = builder.ownerInfo;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.schemaDefinition = builder.schemaDefinition;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * An identifier for a Dataset.
     * </p>
     * 
     * @return An identifier for a Dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The ARN identifier of the Dataset.
     * </p>
     * 
     * @return The ARN identifier of the Dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Display title for a Dataset.
     * </p>
     * 
     * @return Display title for a Dataset.
     */
    public final String datasetTitle() {
        return datasetTitle;
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> - Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> - Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final DatasetKind kind() {
        return DatasetKind.fromValue(kind);
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> - Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> - Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * Description for a Dataset.
     * </p>
     * 
     * @return Description for a Dataset.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * Contact information for a Dataset owner.
     * </p>
     * 
     * @return Contact information for a Dataset owner.
     */
    public final DatasetOwnerInfo ownerInfo() {
        return ownerInfo;
    }

    /**
     * <p>
     * The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Long createTime() {
        return createTime;
    }

    /**
     * <p>
     * The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Definition for a schema on a tabular Dataset.
     * </p>
     * 
     * @return Definition for a schema on a tabular Dataset.
     */
    public final SchemaUnion schemaDefinition() {
        return schemaDefinition;
    }

    /**
     * <p>
     * The unique resource identifier for a Dataset.
     * </p>
     * 
     * @return The unique resource identifier for a Dataset.
     */
    public final String alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(datasetTitle(), other.datasetTitle()) && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(ownerInfo(), other.ownerInfo()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(schemaDefinition(), other.schemaDefinition()) && Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dataset").add("DatasetId", datasetId()).add("DatasetArn", datasetArn())
                .add("DatasetTitle", datasetTitle()).add("Kind", kindAsString()).add("DatasetDescription", datasetDescription())
                .add("OwnerInfo", ownerInfo()).add("CreateTime", createTime()).add("LastModifiedTime", lastModifiedTime())
                .add("SchemaDefinition", schemaDefinition()).add("Alias", alias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "datasetTitle":
            return Optional.ofNullable(clazz.cast(datasetTitle()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "ownerInfo":
            return Optional.ofNullable(clazz.cast(ownerInfo()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Dataset, T> g) {
        return obj -> g.apply((Dataset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dataset> {
        /**
         * <p>
         * An identifier for a Dataset.
         * </p>
         * 
         * @param datasetId
         *        An identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The ARN identifier of the Dataset.
         * </p>
         * 
         * @param datasetArn
         *        The ARN identifier of the Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Display title for a Dataset.
         * </p>
         * 
         * @param datasetTitle
         *        Display title for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTitle(String datasetTitle);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> - Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> - Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> - Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> - Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> - Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(DatasetKind kind);

        /**
         * <p>
         * Description for a Dataset.
         * </p>
         * 
         * @param datasetDescription
         *        Description for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * Contact information for a Dataset owner.
         * </p>
         * 
         * @param ownerInfo
         *        Contact information for a Dataset owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInfo(DatasetOwnerInfo ownerInfo);

        /**
         * <p>
         * Contact information for a Dataset owner.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetOwnerInfo.Builder} avoiding the need to
         * create one manually via {@link DatasetOwnerInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetOwnerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #ownerInfo(DatasetOwnerInfo)}.
         * 
         * @param ownerInfo
         *        a consumer that will call methods on {@link DatasetOwnerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerInfo(DatasetOwnerInfo)
         */
        default Builder ownerInfo(Consumer<DatasetOwnerInfo.Builder> ownerInfo) {
            return ownerInfo(DatasetOwnerInfo.builder().applyMutation(ownerInfo).build());
        }

        /**
         * <p>
         * The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createTime
         *        The timestamp at which the Dataset was created in FinSpace. The value is determined as Epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the Dataset was modified. The value is determined as Epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * 
         * @param schemaDefinition
         *        Definition for a schema on a tabular Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaUnion schemaDefinition);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaUnion.Builder} avoiding the need to create
         * one manually via {@link SchemaUnion#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaDefinition(SchemaUnion)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaUnion)
         */
        default Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return schemaDefinition(SchemaUnion.builder().applyMutation(schemaDefinition).build());
        }

        /**
         * <p>
         * The unique resource identifier for a Dataset.
         * </p>
         * 
         * @param alias
         *        The unique resource identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);
    }

    static final class BuilderImpl implements Builder {
        private String datasetId;

        private String datasetArn;

        private String datasetTitle;

        private String kind;

        private String datasetDescription;

        private DatasetOwnerInfo ownerInfo;

        private Long createTime;

        private Long lastModifiedTime;

        private SchemaUnion schemaDefinition;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            datasetId(model.datasetId);
            datasetArn(model.datasetArn);
            datasetTitle(model.datasetTitle);
            kind(model.kind);
            datasetDescription(model.datasetDescription);
            ownerInfo(model.ownerInfo);
            createTime(model.createTime);
            lastModifiedTime(model.lastModifiedTime);
            schemaDefinition(model.schemaDefinition);
            alias(model.alias);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        @Transient
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        @Transient
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetTitle() {
            return datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        @Transient
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        @Transient
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        @Transient
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        @Transient
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetOwnerInfo.Builder getOwnerInfo() {
            return ownerInfo != null ? ownerInfo.toBuilder() : null;
        }

        public final void setOwnerInfo(DatasetOwnerInfo.BuilderImpl ownerInfo) {
            this.ownerInfo = ownerInfo != null ? ownerInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder ownerInfo(DatasetOwnerInfo ownerInfo) {
            this.ownerInfo = ownerInfo;
            return this;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public Dataset build() {
            return new Dataset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
