/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The response from a describe changeset operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChangesetResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetChangesetResponse.Builder, GetChangesetResponse> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(GetChangesetResponse::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<String> CHANGESET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetArn").getter(getter(GetChangesetResponse::changesetArn)).setter(setter(Builder::changesetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetArn").build()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(GetChangesetResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(GetChangesetResponse::changeTypeAsString))
            .setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sourceParams")
            .getter(getter(GetChangesetResponse::sourceParams))
            .setter(setter(Builder::sourceParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("formatParams")
            .getter(getter(GetChangesetResponse::formatParams))
            .setter(setter(Builder::formatParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createTime").getter(getter(GetChangesetResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetChangesetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ChangesetErrorInfo> ERROR_INFO_FIELD = SdkField
            .<ChangesetErrorInfo> builder(MarshallingType.SDK_POJO).memberName("errorInfo")
            .getter(getter(GetChangesetResponse::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ChangesetErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Long> ACTIVE_UNTIL_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("activeUntilTimestamp").getter(getter(GetChangesetResponse::activeUntilTimestamp))
            .setter(setter(Builder::activeUntilTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeUntilTimestamp").build())
            .build();

    private static final SdkField<String> UPDATES_CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatesChangesetId").getter(getter(GetChangesetResponse::updatesChangesetId))
            .setter(setter(Builder::updatesChangesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatesChangesetId").build())
            .build();

    private static final SdkField<String> UPDATED_BY_CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedByChangesetId").getter(getter(GetChangesetResponse::updatedByChangesetId))
            .setter(setter(Builder::updatedByChangesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedByChangesetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD,
            CHANGESET_ARN_FIELD, DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_PARAMS_FIELD,
            CREATE_TIME_FIELD, STATUS_FIELD, ERROR_INFO_FIELD, ACTIVE_UNTIL_TIMESTAMP_FIELD, UPDATES_CHANGESET_ID_FIELD,
            UPDATED_BY_CHANGESET_ID_FIELD));

    private final String changesetId;

    private final String changesetArn;

    private final String datasetId;

    private final String changeType;

    private final Map<String, String> sourceParams;

    private final Map<String, String> formatParams;

    private final Long createTime;

    private final String status;

    private final ChangesetErrorInfo errorInfo;

    private final Long activeUntilTimestamp;

    private final String updatesChangesetId;

    private final String updatedByChangesetId;

    private GetChangesetResponse(BuilderImpl builder) {
        super(builder);
        this.changesetId = builder.changesetId;
        this.changesetArn = builder.changesetArn;
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceParams = builder.sourceParams;
        this.formatParams = builder.formatParams;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
        this.activeUntilTimestamp = builder.activeUntilTimestamp;
        this.updatesChangesetId = builder.updatesChangesetId;
        this.updatedByChangesetId = builder.updatedByChangesetId;
    }

    /**
     * <p>
     * The unique identifier for a Changeset.
     * </p>
     * 
     * @return The unique identifier for a Changeset.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * <p>
     * The ARN identifier of the Changeset.
     * </p>
     * 
     * @return The ARN identifier of the Changeset.
     */
    public final String changesetArn() {
        return changesetArn;
    }

    /**
     * <p>
     * The unique identifier for the FinSpace Dataset where the Changeset is created.
     * </p>
     * 
     * @return The unique identifier for the FinSpace Dataset where the Changeset is created.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * Type that indicates how a Changeset is applied to a Dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Type that indicates how a Changeset is applied to a Dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final ChangeType changeType() {
        return ChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Type that indicates how a Changeset is applied to a Dataset.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Type that indicates how a Changeset is applied to a Dataset.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceParams() {
        return sourceParams != null && !(sourceParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Options that define the location of the data being ingested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceParams} method.
     * </p>
     * 
     * @return Options that define the location of the data being ingested.
     */
    public final Map<String, String> sourceParams() {
        return sourceParams;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormatParams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormatParams() {
        return formatParams != null && !(formatParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Structure of the source file(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatParams} method.
     * </p>
     * 
     * @return Structure of the source file(s).
     */
    public final Map<String, String> formatParams() {
        return formatParams;
    }

    /**
     * <p>
     * The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Long createTime() {
        return createTime;
    }

    /**
     * <p>
     * The status of Changeset creation operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Changeset creation operation.
     * @see IngestionStatus
     */
    public final IngestionStatus status() {
        return IngestionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of Changeset creation operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Changeset creation operation.
     * @see IngestionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The structure with error messages.
     * </p>
     * 
     * @return The structure with error messages.
     */
    public final ChangesetErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example, the
     * value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long activeUntilTimestamp() {
        return activeUntilTimestamp;
    }

    /**
     * <p>
     * The unique identifier of the Changeset that is being updated.
     * </p>
     * 
     * @return The unique identifier of the Changeset that is being updated.
     */
    public final String updatesChangesetId() {
        return updatesChangesetId;
    }

    /**
     * <p>
     * The unique identifier of the updated Changeset.
     * </p>
     * 
     * @return The unique identifier of the updated Changeset.
     */
    public final String updatedByChangesetId() {
        return updatedByChangesetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceParams() ? sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatParams() ? formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(activeUntilTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatesChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedByChangesetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChangesetResponse)) {
            return false;
        }
        GetChangesetResponse other = (GetChangesetResponse) obj;
        return Objects.equals(changesetId(), other.changesetId()) && Objects.equals(changesetArn(), other.changesetArn())
                && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString())
                && hasSourceParams() == other.hasSourceParams() && Objects.equals(sourceParams(), other.sourceParams())
                && hasFormatParams() == other.hasFormatParams() && Objects.equals(formatParams(), other.formatParams())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorInfo(), other.errorInfo())
                && Objects.equals(activeUntilTimestamp(), other.activeUntilTimestamp())
                && Objects.equals(updatesChangesetId(), other.updatesChangesetId())
                && Objects.equals(updatedByChangesetId(), other.updatedByChangesetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChangesetResponse").add("ChangesetId", changesetId()).add("ChangesetArn", changesetArn())
                .add("DatasetId", datasetId()).add("ChangeType", changeTypeAsString())
                .add("SourceParams", hasSourceParams() ? sourceParams() : null)
                .add("FormatParams", hasFormatParams() ? formatParams() : null).add("CreateTime", createTime())
                .add("Status", statusAsString()).add("ErrorInfo", errorInfo())
                .add("ActiveUntilTimestamp", activeUntilTimestamp()).add("UpdatesChangesetId", updatesChangesetId())
                .add("UpdatedByChangesetId", updatedByChangesetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "changesetArn":
            return Optional.ofNullable(clazz.cast(changesetArn()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        case "sourceParams":
            return Optional.ofNullable(clazz.cast(sourceParams()));
        case "formatParams":
            return Optional.ofNullable(clazz.cast(formatParams()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "activeUntilTimestamp":
            return Optional.ofNullable(clazz.cast(activeUntilTimestamp()));
        case "updatesChangesetId":
            return Optional.ofNullable(clazz.cast(updatesChangesetId()));
        case "updatedByChangesetId":
            return Optional.ofNullable(clazz.cast(updatedByChangesetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChangesetResponse, T> g) {
        return obj -> g.apply((GetChangesetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChangesetResponse> {
        /**
         * <p>
         * The unique identifier for a Changeset.
         * </p>
         * 
         * @param changesetId
         *        The unique identifier for a Changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The ARN identifier of the Changeset.
         * </p>
         * 
         * @param changesetArn
         *        The ARN identifier of the Changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetArn(String changesetArn);

        /**
         * <p>
         * The unique identifier for the FinSpace Dataset where the Changeset is created.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the FinSpace Dataset where the Changeset is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * Type that indicates how a Changeset is applied to a Dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Type that indicates how a Changeset is applied to a Dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded
         *        Changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Type that indicates how a Changeset is applied to a Dataset.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded Changesets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param changeType
         *        Type that indicates how a Changeset is applied to a Dataset.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Changeset is considered as a replacement to all prior loaded Changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPEND</code> - Changeset is considered as an addition to the end of all prior loaded
         *        Changesets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFY</code> - Changeset is considered as a replacement to a specific prior ingested Changeset.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder changeType(ChangeType changeType);

        /**
         * <p>
         * Options that define the location of the data being ingested.
         * </p>
         * 
         * @param sourceParams
         *        Options that define the location of the data being ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParams(Map<String, String> sourceParams);

        /**
         * <p>
         * Structure of the source file(s).
         * </p>
         * 
         * @param formatParams
         *        Structure of the source file(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatParams(Map<String, String> formatParams);

        /**
         * <p>
         * The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createTime
         *        The timestamp at which the Changeset was created in FinSpace. The value is determined as Epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * The status of Changeset creation operation.
         * </p>
         * 
         * @param status
         *        The status of Changeset creation operation.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of Changeset creation operation.
         * </p>
         * 
         * @param status
         *        The status of Changeset creation operation.
         * @see IngestionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionStatus
         */
        Builder status(IngestionStatus status);

        /**
         * <p>
         * The structure with error messages.
         * </p>
         * 
         * @param errorInfo
         *        The structure with error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ChangesetErrorInfo errorInfo);

        /**
         * <p>
         * The structure with error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link ChangesetErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ChangesetErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangesetErrorInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInfo(ChangesetErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ChangesetErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ChangesetErrorInfo)
         */
        default Builder errorInfo(Consumer<ChangesetErrorInfo.Builder> errorInfo) {
            return errorInfo(ChangesetErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For example,
         * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param activeUntilTimestamp
         *        Time until which the Changeset is active. The value is determined as Epoch time in milliseconds. For
         *        example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeUntilTimestamp(Long activeUntilTimestamp);

        /**
         * <p>
         * The unique identifier of the Changeset that is being updated.
         * </p>
         * 
         * @param updatesChangesetId
         *        The unique identifier of the Changeset that is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatesChangesetId(String updatesChangesetId);

        /**
         * <p>
         * The unique identifier of the updated Changeset.
         * </p>
         * 
         * @param updatedByChangesetId
         *        The unique identifier of the updated Changeset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedByChangesetId(String updatedByChangesetId);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private String changesetId;

        private String changesetArn;

        private String datasetId;

        private String changeType;

        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();

        private Long createTime;

        private String status;

        private ChangesetErrorInfo errorInfo;

        private Long activeUntilTimestamp;

        private String updatesChangesetId;

        private String updatedByChangesetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChangesetResponse model) {
            super(model);
            changesetId(model.changesetId);
            changesetArn(model.changesetArn);
            datasetId(model.datasetId);
            changeType(model.changeType);
            sourceParams(model.sourceParams);
            formatParams(model.formatParams);
            createTime(model.createTime);
            status(model.status);
            errorInfo(model.errorInfo);
            activeUntilTimestamp(model.activeUntilTimestamp);
            updatesChangesetId(model.updatesChangesetId);
            updatedByChangesetId(model.updatedByChangesetId);
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        @Transient
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final String getChangesetArn() {
            return changesetArn;
        }

        public final void setChangesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
        }

        @Override
        @Transient
        public final Builder changesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        @Transient
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        @Transient
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        @Transient
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
        }

        @Override
        @Transient
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
        }

        @Override
        @Transient
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
            return this;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(IngestionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ChangesetErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ChangesetErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder errorInfo(ChangesetErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getActiveUntilTimestamp() {
            return activeUntilTimestamp;
        }

        public final void setActiveUntilTimestamp(Long activeUntilTimestamp) {
            this.activeUntilTimestamp = activeUntilTimestamp;
        }

        @Override
        @Transient
        public final Builder activeUntilTimestamp(Long activeUntilTimestamp) {
            this.activeUntilTimestamp = activeUntilTimestamp;
            return this;
        }

        public final String getUpdatesChangesetId() {
            return updatesChangesetId;
        }

        public final void setUpdatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
        }

        @Override
        @Transient
        public final Builder updatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
            return this;
        }

        public final String getUpdatedByChangesetId() {
            return updatedByChangesetId;
        }

        public final void setUpdatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
        }

        @Override
        @Transient
        public final Builder updatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
            return this;
        }

        @Override
        public GetChangesetResponse build() {
            return new GetChangesetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
