/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClientBuilder;
import software.amazon.awssdk.services.finspacedata.model.AccessDeniedException;
import software.amazon.awssdk.services.finspacedata.model.ConflictException;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse;
import software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest;
import software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse;
import software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest;
import software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse;
import software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataException;
import software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest;
import software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse;
import software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest;
import software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse;
import software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest;
import software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse;
import software.amazon.awssdk.services.finspacedata.model.InternalServerException;
import software.amazon.awssdk.services.finspacedata.model.LimitExceededException;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse;
import software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse;
import software.amazon.awssdk.services.finspacedata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.finspacedata.model.ThrottlingException;
import software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest;
import software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse;
import software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest;
import software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse;
import software.amazon.awssdk.services.finspacedata.model.ValidationException;
import software.amazon.awssdk.services.finspacedata.paginators.ListChangesetsIterable;
import software.amazon.awssdk.services.finspacedata.paginators.ListDataViewsIterable;
import software.amazon.awssdk.services.finspacedata.paginators.ListDatasetsIterable;

@SdkPublicApi
@ThreadSafe
public interface FinspaceDataClient
extends SdkClient {
    public static final String SERVICE_NAME = "finspace-api";
    public static final String SERVICE_METADATA_ID = "finspace-api";

    public static FinspaceDataClient create() {
        return (FinspaceDataClient)FinspaceDataClient.builder().build();
    }

    public static FinspaceDataClientBuilder builder() {
        return new DefaultFinspaceDataClientBuilder();
    }

    default public CreateChangesetResponse createChangeset(CreateChangesetRequest createChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public CreateChangesetResponse createChangeset(Consumer<CreateChangesetRequest.Builder> createChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.createChangeset((CreateChangesetRequest)((Object)((CreateChangesetRequest.Builder)CreateChangesetRequest.builder().applyMutation(createChangesetRequest)).build()));
    }

    default public CreateDataViewResponse createDataView(CreateDataViewRequest createDataViewRequest) throws InternalServerException, ThrottlingException, ValidationException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public CreateDataViewResponse createDataView(Consumer<CreateDataViewRequest.Builder> createDataViewRequest) throws InternalServerException, ThrottlingException, ValidationException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.createDataView((CreateDataViewRequest)((Object)((CreateDataViewRequest.Builder)CreateDataViewRequest.builder().applyMutation(createDataViewRequest)).build()));
    }

    default public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.createDataset((CreateDatasetRequest)((Object)((CreateDatasetRequest.Builder)CreateDatasetRequest.builder().applyMutation(createDatasetRequest)).build()));
    }

    default public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.deleteDataset((DeleteDatasetRequest)((Object)((DeleteDatasetRequest.Builder)DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest)).build()));
    }

    default public GetChangesetResponse getChangeset(GetChangesetRequest getChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetChangesetResponse getChangeset(Consumer<GetChangesetRequest.Builder> getChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getChangeset((GetChangesetRequest)((Object)((GetChangesetRequest.Builder)GetChangesetRequest.builder().applyMutation(getChangesetRequest)).build()));
    }

    default public GetDataViewResponse getDataView(GetDataViewRequest getDataViewRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetDataViewResponse getDataView(Consumer<GetDataViewRequest.Builder> getDataViewRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getDataView((GetDataViewRequest)((Object)((GetDataViewRequest.Builder)GetDataViewRequest.builder().applyMutation(getDataViewRequest)).build()));
    }

    default public GetDatasetResponse getDataset(GetDatasetRequest getDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetDatasetResponse getDataset(Consumer<GetDatasetRequest.Builder> getDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getDataset((GetDatasetRequest)((Object)((GetDatasetRequest.Builder)GetDatasetRequest.builder().applyMutation(getDatasetRequest)).build()));
    }

    default public GetProgrammaticAccessCredentialsResponse getProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest getProgrammaticAccessCredentialsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetProgrammaticAccessCredentialsResponse getProgrammaticAccessCredentials(Consumer<GetProgrammaticAccessCredentialsRequest.Builder> getProgrammaticAccessCredentialsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getProgrammaticAccessCredentials((GetProgrammaticAccessCredentialsRequest)((Object)((GetProgrammaticAccessCredentialsRequest.Builder)GetProgrammaticAccessCredentialsRequest.builder().applyMutation(getProgrammaticAccessCredentialsRequest)).build()));
    }

    default public GetWorkingLocationResponse getWorkingLocation(GetWorkingLocationRequest getWorkingLocationRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetWorkingLocationResponse getWorkingLocation(Consumer<GetWorkingLocationRequest.Builder> getWorkingLocationRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getWorkingLocation((GetWorkingLocationRequest)((Object)((GetWorkingLocationRequest.Builder)GetWorkingLocationRequest.builder().applyMutation(getWorkingLocationRequest)).build()));
    }

    default public ListChangesetsResponse listChangesets(ListChangesetsRequest listChangesetsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListChangesetsResponse listChangesets(Consumer<ListChangesetsRequest.Builder> listChangesetsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listChangesets((ListChangesetsRequest)((Object)((ListChangesetsRequest.Builder)ListChangesetsRequest.builder().applyMutation(listChangesetsRequest)).build()));
    }

    default public ListChangesetsIterable listChangesetsPaginator(ListChangesetsRequest listChangesetsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListChangesetsIterable listChangesetsPaginator(Consumer<ListChangesetsRequest.Builder> listChangesetsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listChangesetsPaginator((ListChangesetsRequest)((Object)((ListChangesetsRequest.Builder)ListChangesetsRequest.builder().applyMutation(listChangesetsRequest)).build()));
    }

    default public ListDataViewsResponse listDataViews(ListDataViewsRequest listDataViewsRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListDataViewsResponse listDataViews(Consumer<ListDataViewsRequest.Builder> listDataViewsRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listDataViews((ListDataViewsRequest)((Object)((ListDataViewsRequest.Builder)ListDataViewsRequest.builder().applyMutation(listDataViewsRequest)).build()));
    }

    default public ListDataViewsIterable listDataViewsPaginator(ListDataViewsRequest listDataViewsRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListDataViewsIterable listDataViewsPaginator(Consumer<ListDataViewsRequest.Builder> listDataViewsRequest) throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listDataViewsPaginator((ListDataViewsRequest)((Object)((ListDataViewsRequest.Builder)ListDataViewsRequest.builder().applyMutation(listDataViewsRequest)).build()));
    }

    default public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listDatasets((ListDatasetsRequest)((Object)((ListDatasetsRequest.Builder)ListDatasetsRequest.builder().applyMutation(listDatasetsRequest)).build()));
    }

    default public ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.listDatasetsPaginator((ListDatasetsRequest)((Object)((ListDatasetsRequest.Builder)ListDatasetsRequest.builder().applyMutation(listDatasetsRequest)).build()));
    }

    default public UpdateChangesetResponse updateChangeset(UpdateChangesetRequest updateChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public UpdateChangesetResponse updateChangeset(Consumer<UpdateChangesetRequest.Builder> updateChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.updateChangeset((UpdateChangesetRequest)((Object)((UpdateChangesetRequest.Builder)UpdateChangesetRequest.builder().applyMutation(updateChangesetRequest)).build()));
    }

    default public UpdateDatasetResponse updateDataset(UpdateDatasetRequest updateDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDatasetResponse updateDataset(Consumer<UpdateDatasetRequest.Builder> updateDatasetRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.updateDataset((UpdateDatasetRequest)((Object)((UpdateDatasetRequest.Builder)UpdateDatasetRequest.builder().applyMutation(updateDatasetRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"finspace-api");
    }
}

