/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateUserToPermissionGroupRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<AssociateUserToPermissionGroupRequest.Builder, AssociateUserToPermissionGroupRequest> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionGroupId").getter(getter(AssociateUserToPermissionGroupRequest::permissionGroupId))
            .setter(setter(Builder::permissionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("permissionGroupId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(AssociateUserToPermissionGroupRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(AssociateUserToPermissionGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD,
            USER_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String permissionGroupId;

    private final String userId;

    private final String clientToken;

    private AssociateUserToPermissionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.permissionGroupId = builder.permissionGroupId;
        this.userId = builder.userId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier for the permission group.
     * </p>
     * 
     * @return The unique identifier for the permission group.
     */
    public final String permissionGroupId() {
        return permissionGroupId;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateUserToPermissionGroupRequest)) {
            return false;
        }
        AssociateUserToPermissionGroupRequest other = (AssociateUserToPermissionGroupRequest) obj;
        return Objects.equals(permissionGroupId(), other.permissionGroupId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateUserToPermissionGroupRequest").add("PermissionGroupId", permissionGroupId())
                .add("UserId", userId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionGroupId":
            return Optional.ofNullable(clazz.cast(permissionGroupId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateUserToPermissionGroupRequest, T> g) {
        return obj -> g.apply((AssociateUserToPermissionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateUserToPermissionGroupRequest> {
        /**
         * <p>
         * The unique identifier for the permission group.
         * </p>
         * 
         * @param permissionGroupId
         *        The unique identifier for the permission group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroupId(String permissionGroupId);

        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String permissionGroupId;

        private String userId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateUserToPermissionGroupRequest model) {
            super(model);
            permissionGroupId(model.permissionGroupId);
            userId(model.userId);
            clientToken(model.clientToken);
        }

        public final String getPermissionGroupId() {
            return permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateUserToPermissionGroupRequest build() {
            return new AssociateUserToPermissionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
