/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Changeset Error Category
 */
@Generated("software.amazon.awssdk:codegen")
public enum ErrorCategory {
    VALIDATION("VALIDATION"),

    SERVICE_QUOTA_EXCEEDED("SERVICE_QUOTA_EXCEEDED"),

    ACCESS_DENIED("ACCESS_DENIED"),

    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),

    THROTTLING("THROTTLING"),

    INTERNAL_SERVICE_EXCEPTION("INTERNAL_SERVICE_EXCEPTION"),

    CANCELLED("CANCELLED"),

    USER_RECOVERABLE("USER_RECOVERABLE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCategory> VALUE_MAP = EnumUtils.uniqueIndex(ErrorCategory.class,
            ErrorCategory::toString);

    private final String value;

    private ErrorCategory(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ErrorCategory corresponding to the value
     */
    public static ErrorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ErrorCategory}s
     */
    public static Set<ErrorCategory> knownValues() {
        Set<ErrorCategory> knownValues = EnumSet.allOf(ErrorCategory.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
