/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataViewStatus {
    RUNNING("RUNNING"),
    STARTING("STARTING"),
    FAILED("FAILED"),
    CANCELLED("CANCELLED"),
    TIMEOUT("TIMEOUT"),
    SUCCESS("SUCCESS"),
    PENDING("PENDING"),
    FAILED_CLEANUP_FAILED("FAILED_CLEANUP_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataViewStatus> VALUE_MAP;
    private final String value;

    private DataViewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataViewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataViewStatus> knownValues() {
        EnumSet<DataViewStatus> knownValues = EnumSet.allOf(DataViewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataViewStatus.class, DataViewStatus::toString);
    }
}

