/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.ApplicationPermission;
import software.amazon.awssdk.services.finspacedata.model.ApplicationPermissionListCopier;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupMembershipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionGroup> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionGroupId").getter(PermissionGroup.getter(PermissionGroup::permissionGroupId)).setter(PermissionGroup.setter(Builder::permissionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PermissionGroup.getter(PermissionGroup::name)).setter(PermissionGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PermissionGroup.getter(PermissionGroup::description)).setter(PermissionGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> APPLICATION_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationPermissions").getter(PermissionGroup.getter(PermissionGroup::applicationPermissionsAsStrings)).setter(PermissionGroup.setter(Builder::applicationPermissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(PermissionGroup.getter(PermissionGroup::createTime)).setter(PermissionGroup.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(PermissionGroup.getter(PermissionGroup::lastModifiedTime)).setter(PermissionGroup.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipStatus").getter(PermissionGroup.getter(PermissionGroup::membershipStatusAsString)).setter(PermissionGroup.setter(Builder::membershipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, APPLICATION_PERMISSIONS_FIELD, CREATE_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MEMBERSHIP_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String permissionGroupId;
    private final String name;
    private final String description;
    private final List<String> applicationPermissions;
    private final Long createTime;
    private final Long lastModifiedTime;
    private final String membershipStatus;

    private PermissionGroup(BuilderImpl builder) {
        this.permissionGroupId = builder.permissionGroupId;
        this.name = builder.name;
        this.description = builder.description;
        this.applicationPermissions = builder.applicationPermissions;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.membershipStatus = builder.membershipStatus;
    }

    public final String permissionGroupId() {
        return this.permissionGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<ApplicationPermission> applicationPermissions() {
        return ApplicationPermissionListCopier.copyStringToEnum(this.applicationPermissions);
    }

    public final boolean hasApplicationPermissions() {
        return this.applicationPermissions != null && !(this.applicationPermissions instanceof SdkAutoConstructList);
    }

    public final List<String> applicationPermissionsAsStrings() {
        return this.applicationPermissions;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final PermissionGroupMembershipStatus membershipStatus() {
        return PermissionGroupMembershipStatus.fromValue(this.membershipStatus);
    }

    public final String membershipStatusAsString() {
        return this.membershipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationPermissions() ? this.applicationPermissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroup)) {
            return false;
        }
        PermissionGroup other = (PermissionGroup)obj;
        return Objects.equals(this.permissionGroupId(), other.permissionGroupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasApplicationPermissions() == other.hasApplicationPermissions() && Objects.equals(this.applicationPermissionsAsStrings(), other.applicationPermissionsAsStrings()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.membershipStatusAsString(), other.membershipStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionGroup").add("PermissionGroupId", (Object)this.permissionGroupId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ApplicationPermissions", this.hasApplicationPermissions() ? this.applicationPermissionsAsStrings() : null).add("CreateTime", (Object)this.createTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MembershipStatus", (Object)this.membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionGroupId": {
                return Optional.ofNullable(clazz.cast(this.permissionGroupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "applicationPermissions": {
                return Optional.ofNullable(clazz.cast(this.applicationPermissionsAsStrings()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "membershipStatus": {
                return Optional.ofNullable(clazz.cast(this.membershipStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionGroup, T> g) {
        return obj -> g.apply((PermissionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permissionGroupId;
        private String name;
        private String description;
        private List<String> applicationPermissions = DefaultSdkAutoConstructList.getInstance();
        private Long createTime;
        private Long lastModifiedTime;
        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionGroup model) {
            this.permissionGroupId(model.permissionGroupId);
            this.name(model.name);
            this.description(model.description);
            this.applicationPermissionsWithStrings(model.applicationPermissions);
            this.createTime(model.createTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.membershipStatus(model.membershipStatus);
        }

        public final String getPermissionGroupId() {
            return this.permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getApplicationPermissions() {
            if (this.applicationPermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationPermissions;
        }

        public final void setApplicationPermissions(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
        }

        @Override
        public final Builder applicationPermissionsWithStrings(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissionsWithStrings(String ... applicationPermissions) {
            this.applicationPermissionsWithStrings(Arrays.asList(applicationPermissions));
            return this;
        }

        @Override
        public final Builder applicationPermissions(Collection<ApplicationPermission> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copyEnumToString(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissions(ApplicationPermission ... applicationPermissions) {
            this.applicationPermissions(Arrays.asList(applicationPermissions));
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getMembershipStatus() {
            return this.membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public PermissionGroup build() {
            return new PermissionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionGroup> {
        public Builder permissionGroupId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder applicationPermissionsWithStrings(Collection<String> var1);

        public Builder applicationPermissionsWithStrings(String ... var1);

        public Builder applicationPermissions(Collection<ApplicationPermission> var1);

        public Builder applicationPermissions(ApplicationPermission ... var1);

        public Builder createTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder membershipStatus(String var1);

        public Builder membershipStatus(PermissionGroupMembershipStatus var1);
    }
}

