/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient;
import software.amazon.awssdk.services.finspacedata.model.DataViewSummary;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse;

public class ListDataViewsPublisher
implements SdkPublisher<ListDataViewsResponse> {
    private final FinspaceDataAsyncClient client;
    private final ListDataViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataViewsPublisher(FinspaceDataAsyncClient client, ListDataViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataViewsPublisher(FinspaceDataAsyncClient client, ListDataViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataViewSummary> dataViews() {
        Function<ListDataViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataViews() != null) {
                return response.dataViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataViewsResponseFetcher
    implements AsyncPageFetcher<ListDataViewsResponse> {
        private ListDataViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataViewsResponse> nextPage(ListDataViewsResponse previousPage) {
            if (previousPage == null) {
                return ListDataViewsPublisher.this.client.listDataViews(ListDataViewsPublisher.this.firstRequest);
            }
            return ListDataViewsPublisher.this.client.listDataViews((ListDataViewsRequest)((Object)ListDataViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

