/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.ApiAccess;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupMembershipStatus;
import software.amazon.awssdk.services.finspacedata.model.UserStatus;
import software.amazon.awssdk.services.finspacedata.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserByPermissionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserByPermissionGroup> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UserByPermissionGroup.getter(UserByPermissionGroup::userId)).setter(UserByPermissionGroup.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UserByPermissionGroup.getter(UserByPermissionGroup::statusAsString)).setter(UserByPermissionGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(UserByPermissionGroup.getter(UserByPermissionGroup::firstName)).setter(UserByPermissionGroup.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(UserByPermissionGroup.getter(UserByPermissionGroup::lastName)).setter(UserByPermissionGroup.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(UserByPermissionGroup.getter(UserByPermissionGroup::emailAddress)).setter(UserByPermissionGroup.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UserByPermissionGroup.getter(UserByPermissionGroup::typeAsString)).setter(UserByPermissionGroup.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> API_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccess").getter(UserByPermissionGroup.getter(UserByPermissionGroup::apiAccessAsString)).setter(UserByPermissionGroup.setter(Builder::apiAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()}).build();
    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccessPrincipalArn").getter(UserByPermissionGroup.getter(UserByPermissionGroup::apiAccessPrincipalArn)).setter(UserByPermissionGroup.setter(Builder::apiAccessPrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipStatus").getter(UserByPermissionGroup.getter(UserByPermissionGroup::membershipStatusAsString)).setter(UserByPermissionGroup.setter(Builder::membershipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, STATUS_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, TYPE_FIELD, API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD, MEMBERSHIP_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String status;
    private final String firstName;
    private final String lastName;
    private final String emailAddress;
    private final String type;
    private final String apiAccess;
    private final String apiAccessPrincipalArn;
    private final String membershipStatus;

    private UserByPermissionGroup(BuilderImpl builder) {
        this.userId = builder.userId;
        this.status = builder.status;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.membershipStatus = builder.membershipStatus;
    }

    public final String userId() {
        return this.userId;
    }

    public final UserStatus status() {
        return UserStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final UserType type() {
        return UserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(this.apiAccess);
    }

    public final String apiAccessAsString() {
        return this.apiAccess;
    }

    public final String apiAccessPrincipalArn() {
        return this.apiAccessPrincipalArn;
    }

    public final PermissionGroupMembershipStatus membershipStatus() {
        return PermissionGroupMembershipStatus.fromValue(this.membershipStatus);
    }

    public final String membershipStatusAsString() {
        return this.membershipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserByPermissionGroup)) {
            return false;
        }
        UserByPermissionGroup other = (UserByPermissionGroup)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.apiAccessAsString(), other.apiAccessAsString()) && Objects.equals(this.apiAccessPrincipalArn(), other.apiAccessPrincipalArn()) && Objects.equals(this.membershipStatusAsString(), other.membershipStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UserByPermissionGroup").add("UserId", (Object)this.userId()).add("Status", (Object)this.statusAsString()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ApiAccess", (Object)this.apiAccessAsString()).add("ApiAccessPrincipalArn", (Object)this.apiAccessPrincipalArn()).add("MembershipStatus", (Object)this.membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "apiAccess": {
                return Optional.ofNullable(clazz.cast(this.apiAccessAsString()));
            }
            case "apiAccessPrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.apiAccessPrincipalArn()));
            }
            case "membershipStatus": {
                return Optional.ofNullable(clazz.cast(this.membershipStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserByPermissionGroup, T> g) {
        return obj -> g.apply((UserByPermissionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String status;
        private String firstName;
        private String lastName;
        private String emailAddress;
        private String type;
        private String apiAccess;
        private String apiAccessPrincipalArn;
        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UserByPermissionGroup model) {
            this.userId(model.userId);
            this.status(model.status);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.emailAddress(model.emailAddress);
            this.type(model.type);
            this.apiAccess(model.apiAccess);
            this.apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            this.membershipStatus(model.membershipStatus);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApiAccess() {
            return this.apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return this.apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final String getMembershipStatus() {
            return this.membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public UserByPermissionGroup build() {
            return new UserByPermissionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserByPermissionGroup> {
        public Builder userId(String var1);

        public Builder status(String var1);

        public Builder status(UserStatus var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder emailAddress(String var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder apiAccess(String var1);

        public Builder apiAccess(ApiAccess var1);

        public Builder apiAccessPrincipalArn(String var1);

        public Builder membershipStatus(String var1);

        public Builder membershipStatus(PermissionGroupMembershipStatus var1);
    }
}

