/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient;
import software.amazon.awssdk.services.finspacedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroup;

public class ListPermissionGroupsPublisher
implements SdkPublisher<ListPermissionGroupsResponse> {
    private final FinspaceDataAsyncClient client;
    private final ListPermissionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionGroupsPublisher(FinspaceDataAsyncClient client, ListPermissionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionGroupsPublisher(FinspaceDataAsyncClient client, ListPermissionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PermissionGroup> permissionGroups() {
        Function<ListPermissionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionGroups() != null) {
                return response.permissionGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPermissionGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPermissionGroupsResponseFetcher
    implements AsyncPageFetcher<ListPermissionGroupsResponse> {
        private ListPermissionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionGroupsResponse> nextPage(ListPermissionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionGroupsPublisher.this.client.listPermissionGroups(ListPermissionGroupsPublisher.this.firstRequest);
            }
            return ListPermissionGroupsPublisher.this.client.listPermissionGroups((ListPermissionGroupsRequest)((Object)ListPermissionGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

