/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.AwsCredentials;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExternalDataViewAccessDetailsResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetExternalDataViewAccessDetailsResponse> {
    private static final SdkField<AwsCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(GetExternalDataViewAccessDetailsResponse.getter(GetExternalDataViewAccessDetailsResponse::credentials)).setter(GetExternalDataViewAccessDetailsResponse.setter(Builder::credentials)).constructor(AwsCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(GetExternalDataViewAccessDetailsResponse.getter(GetExternalDataViewAccessDetailsResponse::s3Location)).setter(GetExternalDataViewAccessDetailsResponse.setter(Builder::s3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, S3_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("credentials", CREDENTIALS_FIELD);
            this.put("s3Location", S3_LOCATION_FIELD);
        }
    });
    private final AwsCredentials credentials;
    private final S3Location s3Location;

    private GetExternalDataViewAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.s3Location = builder.s3Location;
    }

    public final AwsCredentials credentials() {
        return this.credentials;
    }

    public final S3Location s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExternalDataViewAccessDetailsResponse)) {
            return false;
        }
        GetExternalDataViewAccessDetailsResponse other = (GetExternalDataViewAccessDetailsResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public final String toString() {
        return ToString.builder((String)"GetExternalDataViewAccessDetailsResponse").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("S3Location", (Object)this.s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExternalDataViewAccessDetailsResponse, T> g) {
        return obj -> g.apply((GetExternalDataViewAccessDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private AwsCredentials credentials;
        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExternalDataViewAccessDetailsResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.s3Location(model.s3Location);
        }

        public final AwsCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(AwsCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(AwsCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public GetExternalDataViewAccessDetailsResponse build() {
            return new GetExternalDataViewAccessDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExternalDataViewAccessDetailsResponse> {
        public Builder credentials(AwsCredentials var1);

        default public Builder credentials(Consumer<AwsCredentials.Builder> credentials) {
            return this.credentials((AwsCredentials)((AwsCredentials.Builder)AwsCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }
    }
}

