/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response for creating a data view.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataViewResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<CreateDataViewResponse.Builder, CreateDataViewResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(CreateDataViewResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataViewId").getter(getter(CreateDataViewResponse::dataViewId)).setter(setter(Builder::dataViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATA_VIEW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetId;

    private final String dataViewId;

    private CreateDataViewResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.dataViewId = builder.dataViewId;
    }

    /**
     * <p>
     * The unique identifier of the Dataset used for the Dataview.
     * </p>
     * 
     * @return The unique identifier of the Dataset used for the Dataview.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The unique identifier for the created Dataview.
     * </p>
     * 
     * @return The unique identifier for the created Dataview.
     */
    public final String dataViewId() {
        return dataViewId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataViewId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataViewResponse)) {
            return false;
        }
        CreateDataViewResponse other = (CreateDataViewResponse) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(dataViewId(), other.dataViewId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataViewResponse").add("DatasetId", datasetId()).add("DataViewId", dataViewId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "dataViewId":
            return Optional.ofNullable(clazz.cast(dataViewId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("dataViewId", DATA_VIEW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataViewResponse, T> g) {
        return obj -> g.apply((CreateDataViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataViewResponse> {
        /**
         * <p>
         * The unique identifier of the Dataset used for the Dataview.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier of the Dataset used for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The unique identifier for the created Dataview.
         * </p>
         * 
         * @param dataViewId
         *        The unique identifier for the created Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataViewId(String dataViewId);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private String datasetId;

        private String dataViewId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataViewResponse model) {
            super(model);
            datasetId(model.datasetId);
            dataViewId(model.dataViewId);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDataViewId() {
            return dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        @Override
        public CreateDataViewResponse build() {
            return new CreateDataViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
