/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure for the Dataview destination type parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataViewDestinationTypeParams implements SdkPojo, Serializable,
        ToCopyableBuilder<DataViewDestinationTypeParams.Builder, DataViewDestinationTypeParams> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationType").getter(getter(DataViewDestinationTypeParams::destinationType))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<String> S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("s3DestinationExportFileFormat")
            .getter(getter(DataViewDestinationTypeParams::s3DestinationExportFileFormatAsString))
            .setter(setter(Builder::s3DestinationExportFileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationExportFileFormat")
                    .build()).build();

    private static final SdkField<Map<String, String>> S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("s3DestinationExportFileFormatOptions")
            .getter(getter(DataViewDestinationTypeParams::s3DestinationExportFileFormatOptions))
            .setter(setter(Builder::s3DestinationExportFileFormatOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("s3DestinationExportFileFormatOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD,
            S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD, S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationType;

    private final String s3DestinationExportFileFormat;

    private final Map<String, String> s3DestinationExportFileFormatOptions;

    private DataViewDestinationTypeParams(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.s3DestinationExportFileFormat = builder.s3DestinationExportFileFormat;
        this.s3DestinationExportFileFormatOptions = builder.s3DestinationExportFileFormatOptions;
    }

    /**
     * <p>
     * Destination type for a Dataview.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GLUE_TABLE</code> – Glue table destination type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> – S3 destination type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Destination type for a Dataview.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GLUE_TABLE</code> – Glue table destination type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> – S3 destination type.
     *         </p>
     *         </li>
     */
    public final String destinationType() {
        return destinationType;
    }

    /**
     * <p>
     * Dataview export file format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PARQUET</code> – Parquet export file format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELIMITED_TEXT</code> – Delimited text export file format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DestinationExportFileFormat} will return {@link ExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #s3DestinationExportFileFormatAsString}.
     * </p>
     * 
     * @return Dataview export file format.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PARQUET</code> – Parquet export file format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELIMITED_TEXT</code> – Delimited text export file format.
     *         </p>
     *         </li>
     * @see ExportFileFormat
     */
    public final ExportFileFormat s3DestinationExportFileFormat() {
        return ExportFileFormat.fromValue(s3DestinationExportFileFormat);
    }

    /**
     * <p>
     * Dataview export file format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PARQUET</code> – Parquet export file format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELIMITED_TEXT</code> – Delimited text export file format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DestinationExportFileFormat} will return {@link ExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #s3DestinationExportFileFormatAsString}.
     * </p>
     * 
     * @return Dataview export file format.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PARQUET</code> – Parquet export file format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELIMITED_TEXT</code> – Delimited text export file format.
     *         </p>
     *         </li>
     * @see ExportFileFormat
     */
    public final String s3DestinationExportFileFormatAsString() {
        return s3DestinationExportFileFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3DestinationExportFileFormatOptions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasS3DestinationExportFileFormatOptions() {
        return s3DestinationExportFileFormatOptions != null
                && !(s3DestinationExportFileFormatOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Format Options for S3 Destination type.
     * </p>
     * <p>
     * Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code>
     * </p>
     * <p>
     * <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3DestinationExportFileFormatOptions}
     * method.
     * </p>
     * 
     * @return Format Options for S3 Destination type.</p>
     *         <p>
     *         Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code>
     *         </p>
     *         <p>
     *         <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code>
     */
    public final Map<String, String> s3DestinationExportFileFormatOptions() {
        return s3DestinationExportFileFormatOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationType());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationExportFileFormatAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasS3DestinationExportFileFormatOptions() ? s3DestinationExportFileFormatOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataViewDestinationTypeParams)) {
            return false;
        }
        DataViewDestinationTypeParams other = (DataViewDestinationTypeParams) obj;
        return Objects.equals(destinationType(), other.destinationType())
                && Objects.equals(s3DestinationExportFileFormatAsString(), other.s3DestinationExportFileFormatAsString())
                && hasS3DestinationExportFileFormatOptions() == other.hasS3DestinationExportFileFormatOptions()
                && Objects.equals(s3DestinationExportFileFormatOptions(), other.s3DestinationExportFileFormatOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DataViewDestinationTypeParams")
                .add("DestinationType", destinationType())
                .add("S3DestinationExportFileFormat", s3DestinationExportFileFormatAsString())
                .add("S3DestinationExportFileFormatOptions",
                        hasS3DestinationExportFileFormatOptions() ? s3DestinationExportFileFormatOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationType":
            return Optional.ofNullable(clazz.cast(destinationType()));
        case "s3DestinationExportFileFormat":
            return Optional.ofNullable(clazz.cast(s3DestinationExportFileFormatAsString()));
        case "s3DestinationExportFileFormatOptions":
            return Optional.ofNullable(clazz.cast(s3DestinationExportFileFormatOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationType", DESTINATION_TYPE_FIELD);
        map.put("s3DestinationExportFileFormat", S3_DESTINATION_EXPORT_FILE_FORMAT_FIELD);
        map.put("s3DestinationExportFileFormatOptions", S3_DESTINATION_EXPORT_FILE_FORMAT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataViewDestinationTypeParams, T> g) {
        return obj -> g.apply((DataViewDestinationTypeParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataViewDestinationTypeParams> {
        /**
         * <p>
         * Destination type for a Dataview.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GLUE_TABLE</code> – Glue table destination type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> – S3 destination type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationType
         *        Destination type for a Dataview.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GLUE_TABLE</code> – Glue table destination type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> – S3 destination type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * Dataview export file format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PARQUET</code> – Parquet export file format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELIMITED_TEXT</code> – Delimited text export file format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3DestinationExportFileFormat
         *        Dataview export file format.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PARQUET</code> – Parquet export file format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELIMITED_TEXT</code> – Delimited text export file format.
         *        </p>
         *        </li>
         * @see ExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFileFormat
         */
        Builder s3DestinationExportFileFormat(String s3DestinationExportFileFormat);

        /**
         * <p>
         * Dataview export file format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PARQUET</code> – Parquet export file format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELIMITED_TEXT</code> – Delimited text export file format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3DestinationExportFileFormat
         *        Dataview export file format.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PARQUET</code> – Parquet export file format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELIMITED_TEXT</code> – Delimited text export file format.
         *        </p>
         *        </li>
         * @see ExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFileFormat
         */
        Builder s3DestinationExportFileFormat(ExportFileFormat s3DestinationExportFileFormat);

        /**
         * <p>
         * Format Options for S3 Destination type.
         * </p>
         * <p>
         * Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code>
         * </p>
         * <p>
         * <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code>
         * </p>
         * 
         * @param s3DestinationExportFileFormatOptions
         *        Format Options for S3 Destination type.</p>
         *        <p>
         *        Here is an example of how you could specify the <code>s3DestinationExportFileFormatOptions</code>
         *        </p>
         *        <p>
         *        <code> { "header": "true", "delimiter": ",", "compression": "gzip" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationExportFileFormatOptions(Map<String, String> s3DestinationExportFileFormatOptions);
    }

    static final class BuilderImpl implements Builder {
        private String destinationType;

        private String s3DestinationExportFileFormat;

        private Map<String, String> s3DestinationExportFileFormatOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataViewDestinationTypeParams model) {
            destinationType(model.destinationType);
            s3DestinationExportFileFormat(model.s3DestinationExportFileFormat);
            s3DestinationExportFileFormatOptions(model.s3DestinationExportFileFormatOptions);
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public final String getS3DestinationExportFileFormat() {
            return s3DestinationExportFileFormat;
        }

        public final void setS3DestinationExportFileFormat(String s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat = s3DestinationExportFileFormat;
        }

        @Override
        public final Builder s3DestinationExportFileFormat(String s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat = s3DestinationExportFileFormat;
            return this;
        }

        @Override
        public final Builder s3DestinationExportFileFormat(ExportFileFormat s3DestinationExportFileFormat) {
            this.s3DestinationExportFileFormat(s3DestinationExportFileFormat == null ? null : s3DestinationExportFileFormat
                    .toString());
            return this;
        }

        public final Map<String, String> getS3DestinationExportFileFormatOptions() {
            if (s3DestinationExportFileFormatOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return s3DestinationExportFileFormatOptions;
        }

        public final void setS3DestinationExportFileFormatOptions(Map<String, String> s3DestinationExportFileFormatOptions) {
            this.s3DestinationExportFileFormatOptions = S3DestinationFormatOptionsCopier
                    .copy(s3DestinationExportFileFormatOptions);
        }

        @Override
        public final Builder s3DestinationExportFileFormatOptions(Map<String, String> s3DestinationExportFileFormatOptions) {
            this.s3DestinationExportFileFormatOptions = S3DestinationFormatOptionsCopier
                    .copy(s3DestinationExportFileFormatOptions);
            return this;
        }

        @Override
        public DataViewDestinationTypeParams build() {
            return new DataViewDestinationTypeParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
