/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkingLocationResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetWorkingLocationResponse.Builder, GetWorkingLocationResponse> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(GetWorkingLocationResponse::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Path")
            .getter(getter(GetWorkingLocationResponse::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(GetWorkingLocationResponse::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, S3_PATH_FIELD,
            S3_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3Uri;

    private final String s3Path;

    private final String s3Bucket;

    private GetWorkingLocationResponse(BuilderImpl builder) {
        super(builder);
        this.s3Uri = builder.s3Uri;
        this.s3Path = builder.s3Path;
        this.s3Bucket = builder.s3Bucket;
    }

    /**
     * <p>
     * Returns the Amazon S3 URI for the working location.
     * </p>
     * 
     * @return Returns the Amazon S3 URI for the working location.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Returns the Amazon S3 Path for the working location.
     * </p>
     * 
     * @return Returns the Amazon S3 Path for the working location.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * Returns the Amazon S3 bucket name for the working location.
     * </p>
     * 
     * @return Returns the Amazon S3 bucket name for the working location.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkingLocationResponse)) {
            return false;
        }
        GetWorkingLocationResponse other = (GetWorkingLocationResponse) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(s3Bucket(), other.s3Bucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkingLocationResponse").add("S3Uri", s3Uri()).add("S3Path", s3Path())
                .add("S3Bucket", s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "s3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("s3Path", S3_PATH_FIELD);
        map.put("s3Bucket", S3_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkingLocationResponse, T> g) {
        return obj -> g.apply((GetWorkingLocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkingLocationResponse> {
        /**
         * <p>
         * Returns the Amazon S3 URI for the working location.
         * </p>
         * 
         * @param s3Uri
         *        Returns the Amazon S3 URI for the working location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Returns the Amazon S3 Path for the working location.
         * </p>
         * 
         * @param s3Path
         *        Returns the Amazon S3 Path for the working location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * Returns the Amazon S3 bucket name for the working location.
         * </p>
         * 
         * @param s3Bucket
         *        Returns the Amazon S3 bucket name for the working location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private String s3Uri;

        private String s3Path;

        private String s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkingLocationResponse model) {
            super(model);
            s3Uri(model.s3Uri);
            s3Path(model.s3Path);
            s3Bucket(model.s3Bucket);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        @Override
        public GetWorkingLocationResponse build() {
            return new GetWorkingLocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
