/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of a permission group associated with a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionGroupByUser implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionGroupByUser.Builder, PermissionGroupByUser> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionGroupId").getter(getter(PermissionGroupByUser::permissionGroupId))
            .setter(setter(Builder::permissionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PermissionGroupByUser::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipStatus").getter(getter(PermissionGroupByUser::membershipStatusAsString))
            .setter(setter(Builder::membershipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD,
            NAME_FIELD, MEMBERSHIP_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String permissionGroupId;

    private final String name;

    private final String membershipStatus;

    private PermissionGroupByUser(BuilderImpl builder) {
        this.permissionGroupId = builder.permissionGroupId;
        this.name = builder.name;
        this.membershipStatus = builder.membershipStatus;
    }

    /**
     * <p>
     * The unique identifier for the permission group.
     * </p>
     * 
     * @return The unique identifier for the permission group.
     */
    public final String permissionGroupId() {
        return permissionGroupId;
    }

    /**
     * <p>
     * The name of the permission group.
     * </p>
     * 
     * @return The name of the permission group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates the status of the user within a permission group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link PermissionGroupMembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the user within a permission group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     *         </p>
     *         </li>
     * @see PermissionGroupMembershipStatus
     */
    public final PermissionGroupMembershipStatus membershipStatus() {
        return PermissionGroupMembershipStatus.fromValue(membershipStatus);
    }

    /**
     * <p>
     * Indicates the status of the user within a permission group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link PermissionGroupMembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the user within a permission group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     *         </p>
     *         </li>
     * @see PermissionGroupMembershipStatus
     */
    public final String membershipStatusAsString() {
        return membershipStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(membershipStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroupByUser)) {
            return false;
        }
        PermissionGroupByUser other = (PermissionGroupByUser) obj;
        return Objects.equals(permissionGroupId(), other.permissionGroupId()) && Objects.equals(name(), other.name())
                && Objects.equals(membershipStatusAsString(), other.membershipStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionGroupByUser").add("PermissionGroupId", permissionGroupId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MembershipStatus", membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionGroupId":
            return Optional.ofNullable(clazz.cast(permissionGroupId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "membershipStatus":
            return Optional.ofNullable(clazz.cast(membershipStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permissionGroupId", PERMISSION_GROUP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionGroupByUser, T> g) {
        return obj -> g.apply((PermissionGroupByUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionGroupByUser> {
        /**
         * <p>
         * The unique identifier for the permission group.
         * </p>
         * 
         * @param permissionGroupId
         *        The unique identifier for the permission group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroupId(String permissionGroupId);

        /**
         * <p>
         * The name of the permission group.
         * </p>
         * 
         * @param name
         *        The name of the permission group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the status of the user within a permission group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param membershipStatus
         *        Indicates the status of the user within a permission group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         *        </p>
         *        </li>
         * @see PermissionGroupMembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroupMembershipStatus
         */
        Builder membershipStatus(String membershipStatus);

        /**
         * <p>
         * Indicates the status of the user within a permission group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param membershipStatus
         *        Indicates the status of the user within a permission group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         *        </p>
         *        </li>
         * @see PermissionGroupMembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroupMembershipStatus
         */
        Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus);
    }

    static final class BuilderImpl implements Builder {
        private String permissionGroupId;

        private String name;

        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionGroupByUser model) {
            permissionGroupId(model.permissionGroupId);
            name(model.name);
            membershipStatus(model.membershipStatus);
        }

        public final String getPermissionGroupId() {
            return permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMembershipStatus() {
            return membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        @Override
        public PermissionGroupByUser build() {
            return new PermissionGroupByUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
