/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of a user associated with a permission group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserByPermissionGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<UserByPermissionGroup.Builder, UserByPermissionGroup> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(UserByPermissionGroup::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UserByPermissionGroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstName").getter(getter(UserByPermissionGroup::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastName").getter(getter(UserByPermissionGroup::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(UserByPermissionGroup::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UserByPermissionGroup::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> API_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccess").getter(getter(UserByPermissionGroup::apiAccessAsString)).setter(setter(Builder::apiAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()).build();

    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccessPrincipalArn").getter(getter(UserByPermissionGroup::apiAccessPrincipalArn))
            .setter(setter(Builder::apiAccessPrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipStatus").getter(getter(UserByPermissionGroup::membershipStatusAsString))
            .setter(setter(Builder::membershipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, STATUS_FIELD,
            FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, TYPE_FIELD, API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD,
            MEMBERSHIP_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String status;

    private final String firstName;

    private final String lastName;

    private final String emailAddress;

    private final String type;

    private final String apiAccess;

    private final String apiAccessPrincipalArn;

    private final String membershipStatus;

    private UserByPermissionGroup(BuilderImpl builder) {
        this.userId = builder.userId;
        this.status = builder.status;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.membershipStatus = builder.membershipStatus;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The current status of the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The user creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user is created and is currently active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user is currently inactive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the user. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The user creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user is created and is currently active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user is currently inactive.
     *         </p>
     *         </li>
     * @see UserStatus
     */
    public final UserStatus status() {
        return UserStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The user creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user is created and is currently active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user is currently inactive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the user. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The user creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user is created and is currently active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user is currently inactive.
     *         </p>
     *         </li>
     * @see UserStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The email address of the user. The email address serves as a unique identifier for each user and cannot be
     * changed after it's created.
     * </p>
     * 
     * @return The email address of the user. The email address serves as a unique identifier for each user and cannot
     *         be changed after it's created.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * Indicates the type of user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permission group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final UserType type() {
        return UserType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of user.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permission group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Indicates whether the user can access FinSpace API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the API operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any API operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the user can access FinSpace API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the API operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any API operations.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(apiAccess);
    }

    /**
     * <p>
     * Indicates whether the user can access FinSpace API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the API operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any API operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the user can access FinSpace API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the API operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any API operations.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final String apiAccessAsString() {
        return apiAccess;
    }

    /**
     * <p>
     * The IAM ARN identifier that is attached to FinSpace API calls.
     * </p>
     * 
     * @return The IAM ARN identifier that is attached to FinSpace API calls.
     */
    public final String apiAccessPrincipalArn() {
        return apiAccessPrincipalArn;
    }

    /**
     * <p>
     * Indicates the status of the user within a permission group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link PermissionGroupMembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the user within a permission group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     *         </p>
     *         </li>
     * @see PermissionGroupMembershipStatus
     */
    public final PermissionGroupMembershipStatus membershipStatus() {
        return PermissionGroupMembershipStatus.fromValue(membershipStatus);
    }

    /**
     * <p>
     * Indicates the status of the user within a permission group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link PermissionGroupMembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the user within a permission group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
     *         </p>
     *         </li>
     * @see PermissionGroupMembershipStatus
     */
    public final String membershipStatusAsString() {
        return membershipStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserByPermissionGroup)) {
            return false;
        }
        UserByPermissionGroup other = (UserByPermissionGroup) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(apiAccessAsString(), other.apiAccessAsString())
                && Objects.equals(apiAccessPrincipalArn(), other.apiAccessPrincipalArn())
                && Objects.equals(membershipStatusAsString(), other.membershipStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserByPermissionGroup").add("UserId", userId()).add("Status", statusAsString())
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("ApiAccess", apiAccessAsString())
                .add("ApiAccessPrincipalArn", apiAccessPrincipalArn()).add("MembershipStatus", membershipStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "firstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "lastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "apiAccess":
            return Optional.ofNullable(clazz.cast(apiAccessAsString()));
        case "apiAccessPrincipalArn":
            return Optional.ofNullable(clazz.cast(apiAccessPrincipalArn()));
        case "membershipStatus":
            return Optional.ofNullable(clazz.cast(membershipStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userId", USER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("emailAddress", EMAIL_ADDRESS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("apiAccess", API_ACCESS_FIELD);
        map.put("apiAccessPrincipalArn", API_ACCESS_PRINCIPAL_ARN_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserByPermissionGroup, T> g) {
        return obj -> g.apply((UserByPermissionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserByPermissionGroup> {
        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The current status of the user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The user creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user is created and is currently active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user is currently inactive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the user. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The user creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user is created and is currently active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user is currently inactive.
         *        </p>
         *        </li>
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The user creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user is created and is currently active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user is currently inactive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the user. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The user creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user is created and is currently active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user is currently inactive.
         *        </p>
         *        </li>
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder status(UserStatus status);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param firstName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param lastName
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The email address of the user. The email address serves as a unique identifier for each user and cannot be
         * changed after it's created.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user. The email address serves as a unique identifier for each user and
         *        cannot be changed after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * Indicates the type of user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Indicates the type of user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permission group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of user.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Indicates the type of user.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permission group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(UserType type);

        /**
         * <p>
         * Indicates whether the user can access FinSpace API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the API operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any API operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        Indicates whether the user can access FinSpace API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the API operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any API operations.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(String apiAccess);

        /**
         * <p>
         * Indicates whether the user can access FinSpace API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the API operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any API operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        Indicates whether the user can access FinSpace API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the API operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any API operations.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(ApiAccess apiAccess);

        /**
         * <p>
         * The IAM ARN identifier that is attached to FinSpace API calls.
         * </p>
         * 
         * @param apiAccessPrincipalArn
         *        The IAM ARN identifier that is attached to FinSpace API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiAccessPrincipalArn(String apiAccessPrincipalArn);

        /**
         * <p>
         * Indicates the status of the user within a permission group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param membershipStatus
         *        Indicates the status of the user within a permission group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         *        </p>
         *        </li>
         * @see PermissionGroupMembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroupMembershipStatus
         */
        Builder membershipStatus(String membershipStatus);

        /**
         * <p>
         * Indicates the status of the user within a permission group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param membershipStatus
         *        Indicates the status of the user within a permission group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADDITION_IN_PROGRESS</code> – The user is currently being added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADDITION_SUCCESS</code> – The user is successfully added to the permission group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVAL_IN_PROGRESS</code> – The user is currently being removed from the permission group.
         *        </p>
         *        </li>
         * @see PermissionGroupMembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroupMembershipStatus
         */
        Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String status;

        private String firstName;

        private String lastName;

        private String emailAddress;

        private String type;

        private String apiAccess;

        private String apiAccessPrincipalArn;

        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UserByPermissionGroup model) {
            userId(model.userId);
            status(model.status);
            firstName(model.firstName);
            lastName(model.lastName);
            emailAddress(model.emailAddress);
            type(model.type);
            apiAccess(model.apiAccess);
            apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            membershipStatus(model.membershipStatus);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApiAccess() {
            return apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final String getMembershipStatus() {
            return membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        @Override
        public UserByPermissionGroup build() {
            return new UserByPermissionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
