/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPermissionGroupResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetPermissionGroupResponse.Builder, GetPermissionGroupResponse> {
    private static final SdkField<PermissionGroup> PERMISSION_GROUP_FIELD = SdkField
            .<PermissionGroup> builder(MarshallingType.SDK_POJO).memberName("permissionGroup")
            .getter(getter(GetPermissionGroupResponse::permissionGroup)).setter(setter(Builder::permissionGroup))
            .constructor(PermissionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PermissionGroup permissionGroup;

    private GetPermissionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.permissionGroup = builder.permissionGroup;
    }

    /**
     * Returns the value of the PermissionGroup property for this object.
     * 
     * @return The value of the PermissionGroup property for this object.
     */
    public final PermissionGroup permissionGroup() {
        return permissionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPermissionGroupResponse)) {
            return false;
        }
        GetPermissionGroupResponse other = (GetPermissionGroupResponse) obj;
        return Objects.equals(permissionGroup(), other.permissionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPermissionGroupResponse").add("PermissionGroup", permissionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionGroup":
            return Optional.ofNullable(clazz.cast(permissionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permissionGroup", PERMISSION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPermissionGroupResponse, T> g) {
        return obj -> g.apply((GetPermissionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPermissionGroupResponse> {
        /**
         * Sets the value of the PermissionGroup property for this object.
         *
         * @param permissionGroup
         *        The new value for the PermissionGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroup(PermissionGroup permissionGroup);

        /**
         * Sets the value of the PermissionGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PermissionGroup.Builder} avoiding the
         * need to create one manually via {@link PermissionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #permissionGroup(PermissionGroup)}.
         * 
         * @param permissionGroup
         *        a consumer that will call methods on {@link PermissionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionGroup(PermissionGroup)
         */
        default Builder permissionGroup(Consumer<PermissionGroup.Builder> permissionGroup) {
            return permissionGroup(PermissionGroup.builder().applyMutation(permissionGroup).build());
        }
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private PermissionGroup permissionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPermissionGroupResponse model) {
            super(model);
            permissionGroup(model.permissionGroup);
        }

        public final PermissionGroup.Builder getPermissionGroup() {
            return permissionGroup != null ? permissionGroup.toBuilder() : null;
        }

        public final void setPermissionGroup(PermissionGroup.BuilderImpl permissionGroup) {
            this.permissionGroup = permissionGroup != null ? permissionGroup.build() : null;
        }

        @Override
        public final Builder permissionGroup(PermissionGroup permissionGroup) {
            this.permissionGroup = permissionGroup;
            return this;
        }

        @Override
        public GetPermissionGroupResponse build() {
            return new GetPermissionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
