/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.DatasetKind;
import software.amazon.awssdk.services.finspacedata.model.DatasetStatus;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.SchemaUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatasetResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(GetDatasetResponse.getter(GetDatasetResponse::datasetId)).setter(GetDatasetResponse.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(GetDatasetResponse.getter(GetDatasetResponse::datasetArn)).setter(GetDatasetResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetTitle").getter(GetDatasetResponse.getter(GetDatasetResponse::datasetTitle)).setter(GetDatasetResponse.setter(Builder::datasetTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()}).build();
    private static final SdkField<String> KIND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kind").getter(GetDatasetResponse.getter(GetDatasetResponse::kindAsString)).setter(GetDatasetResponse.setter(Builder::kind)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()}).build();
    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetDescription").getter(GetDatasetResponse.getter(GetDatasetResponse::datasetDescription)).setter(GetDatasetResponse.setter(Builder::datasetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(GetDatasetResponse.getter(GetDatasetResponse::createTime)).setter(GetDatasetResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(GetDatasetResponse.getter(GetDatasetResponse::lastModifiedTime)).setter(GetDatasetResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schemaDefinition").getter(GetDatasetResponse.getter(GetDatasetResponse::schemaDefinition)).setter(GetDatasetResponse.setter(Builder::schemaDefinition)).constructor(SchemaUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(GetDatasetResponse.getter(GetDatasetResponse::alias)).setter(GetDatasetResponse.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDatasetResponse.getter(GetDatasetResponse::statusAsString)).setter(GetDatasetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, DATASET_ARN_FIELD, DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, CREATE_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SCHEMA_DEFINITION_FIELD, ALIAS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDatasetResponse.memberNameToFieldInitializer();
    private final String datasetId;
    private final String datasetArn;
    private final String datasetTitle;
    private final String kind;
    private final String datasetDescription;
    private final Long createTime;
    private final Long lastModifiedTime;
    private final SchemaUnion schemaDefinition;
    private final String alias;
    private final String status;

    private GetDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.schemaDefinition = builder.schemaDefinition;
        this.alias = builder.alias;
        this.status = builder.status;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetTitle() {
        return this.datasetTitle;
    }

    public final DatasetKind kind() {
        return DatasetKind.fromValue(this.kind);
    }

    public final String kindAsString() {
        return this.kind;
    }

    public final String datasetDescription() {
        return this.datasetDescription;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final SchemaUnion schemaDefinition() {
        return this.schemaDefinition;
    }

    public final String alias() {
        return this.alias;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatasetResponse)) {
            return false;
        }
        GetDatasetResponse other = (GetDatasetResponse)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetTitle(), other.datasetTitle()) && Objects.equals(this.kindAsString(), other.kindAsString()) && Objects.equals(this.datasetDescription(), other.datasetDescription()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatasetResponse").add("DatasetId", (Object)this.datasetId()).add("DatasetArn", (Object)this.datasetArn()).add("DatasetTitle", (Object)this.datasetTitle()).add("Kind", (Object)this.kindAsString()).add("DatasetDescription", (Object)this.datasetDescription()).add("CreateTime", (Object)this.createTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SchemaDefinition", (Object)this.schemaDefinition()).add("Alias", (Object)this.alias()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "datasetTitle": {
                return Optional.ofNullable(clazz.cast(this.datasetTitle()));
            }
            case "kind": {
                return Optional.ofNullable(clazz.cast(this.kindAsString()));
            }
            case "datasetDescription": {
                return Optional.ofNullable(clazz.cast(this.datasetDescription()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "schemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetTitle", DATASET_TITLE_FIELD);
        map.put("kind", KIND_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("schemaDefinition", SCHEMA_DEFINITION_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDatasetResponse, T> g) {
        return obj -> g.apply((GetDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String datasetId;
        private String datasetArn;
        private String datasetTitle;
        private String kind;
        private String datasetDescription;
        private Long createTime;
        private Long lastModifiedTime;
        private SchemaUnion schemaDefinition;
        private String alias;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatasetResponse model) {
            super(model);
            this.datasetId(model.datasetId);
            this.datasetArn(model.datasetArn);
            this.datasetTitle(model.datasetTitle);
            this.kind(model.kind);
            this.datasetDescription(model.datasetDescription);
            this.createTime(model.createTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.schemaDefinition(model.schemaDefinition);
            this.alias(model.alias);
            this.status(model.status);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetTitle() {
            return this.datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return this.kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return this.datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return this.schemaDefinition != null ? this.schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDatasetResponse build() {
            return new GetDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatasetResponse> {
        public Builder datasetId(String var1);

        public Builder datasetArn(String var1);

        public Builder datasetTitle(String var1);

        public Builder kind(String var1);

        public Builder kind(DatasetKind var1);

        public Builder datasetDescription(String var1);

        public Builder createTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder schemaDefinition(SchemaUnion var1);

        default public Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return this.schemaDefinition((SchemaUnion)((SchemaUnion.Builder)SchemaUnion.builder().applyMutation(schemaDefinition)).build());
        }

        public Builder alias(String var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);
    }
}

